/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const AlarmMessageObjectAckType_VARIABLESPEC uint8 = 0x12
const AlarmMessageObjectAckType_LENGTH uint8 = 0x08

// AlarmMessageObjectAckType is the corresponding interface of AlarmMessageObjectAckType
type AlarmMessageObjectAckType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetSyntaxId returns SyntaxId (property field)
	GetSyntaxId() SyntaxIdType
	// GetNumberOfValues returns NumberOfValues (property field)
	GetNumberOfValues() uint8
	// GetEventId returns EventId (property field)
	GetEventId() uint32
	// GetAckStateGoing returns AckStateGoing (property field)
	GetAckStateGoing() State
	// GetAckStateComing returns AckStateComing (property field)
	GetAckStateComing() State
	// IsAlarmMessageObjectAckType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAlarmMessageObjectAckType()
	// CreateBuilder creates a AlarmMessageObjectAckTypeBuilder
	CreateAlarmMessageObjectAckTypeBuilder() AlarmMessageObjectAckTypeBuilder
}

// _AlarmMessageObjectAckType is the data-structure of this message
type _AlarmMessageObjectAckType struct {
	SyntaxId       SyntaxIdType
	NumberOfValues uint8
	EventId        uint32
	AckStateGoing  State
	AckStateComing State
}

var _ AlarmMessageObjectAckType = (*_AlarmMessageObjectAckType)(nil)

// NewAlarmMessageObjectAckType factory function for _AlarmMessageObjectAckType
func NewAlarmMessageObjectAckType(syntaxId SyntaxIdType, numberOfValues uint8, eventId uint32, ackStateGoing State, ackStateComing State) *_AlarmMessageObjectAckType {
	if ackStateGoing == nil {
		panic("ackStateGoing of type State for AlarmMessageObjectAckType must not be nil")
	}
	if ackStateComing == nil {
		panic("ackStateComing of type State for AlarmMessageObjectAckType must not be nil")
	}
	return &_AlarmMessageObjectAckType{SyntaxId: syntaxId, NumberOfValues: numberOfValues, EventId: eventId, AckStateGoing: ackStateGoing, AckStateComing: ackStateComing}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AlarmMessageObjectAckTypeBuilder is a builder for AlarmMessageObjectAckType
type AlarmMessageObjectAckTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(syntaxId SyntaxIdType, numberOfValues uint8, eventId uint32, ackStateGoing State, ackStateComing State) AlarmMessageObjectAckTypeBuilder
	// WithSyntaxId adds SyntaxId (property field)
	WithSyntaxId(SyntaxIdType) AlarmMessageObjectAckTypeBuilder
	// WithNumberOfValues adds NumberOfValues (property field)
	WithNumberOfValues(uint8) AlarmMessageObjectAckTypeBuilder
	// WithEventId adds EventId (property field)
	WithEventId(uint32) AlarmMessageObjectAckTypeBuilder
	// WithAckStateGoing adds AckStateGoing (property field)
	WithAckStateGoing(State) AlarmMessageObjectAckTypeBuilder
	// WithAckStateGoingBuilder adds AckStateGoing (property field) which is build by the builder
	WithAckStateGoingBuilder(func(StateBuilder) StateBuilder) AlarmMessageObjectAckTypeBuilder
	// WithAckStateComing adds AckStateComing (property field)
	WithAckStateComing(State) AlarmMessageObjectAckTypeBuilder
	// WithAckStateComingBuilder adds AckStateComing (property field) which is build by the builder
	WithAckStateComingBuilder(func(StateBuilder) StateBuilder) AlarmMessageObjectAckTypeBuilder
	// Build builds the AlarmMessageObjectAckType or returns an error if something is wrong
	Build() (AlarmMessageObjectAckType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AlarmMessageObjectAckType
}

// NewAlarmMessageObjectAckTypeBuilder() creates a AlarmMessageObjectAckTypeBuilder
func NewAlarmMessageObjectAckTypeBuilder() AlarmMessageObjectAckTypeBuilder {
	return &_AlarmMessageObjectAckTypeBuilder{_AlarmMessageObjectAckType: new(_AlarmMessageObjectAckType)}
}

type _AlarmMessageObjectAckTypeBuilder struct {
	*_AlarmMessageObjectAckType

	collectedErr []error
}

var _ (AlarmMessageObjectAckTypeBuilder) = (*_AlarmMessageObjectAckTypeBuilder)(nil)

func (b *_AlarmMessageObjectAckTypeBuilder) WithMandatoryFields(syntaxId SyntaxIdType, numberOfValues uint8, eventId uint32, ackStateGoing State, ackStateComing State) AlarmMessageObjectAckTypeBuilder {
	return b.WithSyntaxId(syntaxId).WithNumberOfValues(numberOfValues).WithEventId(eventId).WithAckStateGoing(ackStateGoing).WithAckStateComing(ackStateComing)
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithSyntaxId(syntaxId SyntaxIdType) AlarmMessageObjectAckTypeBuilder {
	b.SyntaxId = syntaxId
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithNumberOfValues(numberOfValues uint8) AlarmMessageObjectAckTypeBuilder {
	b.NumberOfValues = numberOfValues
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithEventId(eventId uint32) AlarmMessageObjectAckTypeBuilder {
	b.EventId = eventId
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithAckStateGoing(ackStateGoing State) AlarmMessageObjectAckTypeBuilder {
	b.AckStateGoing = ackStateGoing
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithAckStateGoingBuilder(builderSupplier func(StateBuilder) StateBuilder) AlarmMessageObjectAckTypeBuilder {
	builder := builderSupplier(b.AckStateGoing.CreateStateBuilder())
	var err error
	b.AckStateGoing, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StateBuilder failed"))
	}
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithAckStateComing(ackStateComing State) AlarmMessageObjectAckTypeBuilder {
	b.AckStateComing = ackStateComing
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) WithAckStateComingBuilder(builderSupplier func(StateBuilder) StateBuilder) AlarmMessageObjectAckTypeBuilder {
	builder := builderSupplier(b.AckStateComing.CreateStateBuilder())
	var err error
	b.AckStateComing, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StateBuilder failed"))
	}
	return b
}

func (b *_AlarmMessageObjectAckTypeBuilder) Build() (AlarmMessageObjectAckType, error) {
	if b.AckStateGoing == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ackStateGoing' not set"))
	}
	if b.AckStateComing == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'ackStateComing' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AlarmMessageObjectAckType.deepCopy(), nil
}

func (b *_AlarmMessageObjectAckTypeBuilder) MustBuild() AlarmMessageObjectAckType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AlarmMessageObjectAckTypeBuilder) DeepCopy() any {
	_copy := b.CreateAlarmMessageObjectAckTypeBuilder().(*_AlarmMessageObjectAckTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAlarmMessageObjectAckTypeBuilder creates a AlarmMessageObjectAckTypeBuilder
func (b *_AlarmMessageObjectAckType) CreateAlarmMessageObjectAckTypeBuilder() AlarmMessageObjectAckTypeBuilder {
	if b == nil {
		return NewAlarmMessageObjectAckTypeBuilder()
	}
	return &_AlarmMessageObjectAckTypeBuilder{_AlarmMessageObjectAckType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AlarmMessageObjectAckType) GetSyntaxId() SyntaxIdType {
	return m.SyntaxId
}

func (m *_AlarmMessageObjectAckType) GetNumberOfValues() uint8 {
	return m.NumberOfValues
}

func (m *_AlarmMessageObjectAckType) GetEventId() uint32 {
	return m.EventId
}

func (m *_AlarmMessageObjectAckType) GetAckStateGoing() State {
	return m.AckStateGoing
}

func (m *_AlarmMessageObjectAckType) GetAckStateComing() State {
	return m.AckStateComing
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_AlarmMessageObjectAckType) GetVariableSpec() uint8 {
	return AlarmMessageObjectAckType_VARIABLESPEC
}

func (m *_AlarmMessageObjectAckType) GetLength() uint8 {
	return AlarmMessageObjectAckType_LENGTH
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAlarmMessageObjectAckType(structType any) AlarmMessageObjectAckType {
	if casted, ok := structType.(AlarmMessageObjectAckType); ok {
		return casted
	}
	if casted, ok := structType.(*AlarmMessageObjectAckType); ok {
		return *casted
	}
	return nil
}

func (m *_AlarmMessageObjectAckType) GetTypeName() string {
	return "AlarmMessageObjectAckType"
}

func (m *_AlarmMessageObjectAckType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (variableSpec)
	lengthInBits += 8

	// Const Field (length)
	lengthInBits += 8

	// Simple field (syntaxId)
	lengthInBits += 8

	// Simple field (numberOfValues)
	lengthInBits += 8

	// Simple field (eventId)
	lengthInBits += 32

	// Simple field (ackStateGoing)
	lengthInBits += m.AckStateGoing.GetLengthInBits(ctx)

	// Simple field (ackStateComing)
	lengthInBits += m.AckStateComing.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AlarmMessageObjectAckType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AlarmMessageObjectAckTypeParse(ctx context.Context, theBytes []byte) (AlarmMessageObjectAckType, error) {
	return AlarmMessageObjectAckTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AlarmMessageObjectAckTypeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageObjectAckType, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageObjectAckType, error) {
		return AlarmMessageObjectAckTypeParseWithBuffer(ctx, readBuffer)
	}
}

func AlarmMessageObjectAckTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageObjectAckType, error) {
	v, err := (&_AlarmMessageObjectAckType{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_AlarmMessageObjectAckType) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__alarmMessageObjectAckType AlarmMessageObjectAckType, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AlarmMessageObjectAckType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AlarmMessageObjectAckType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	variableSpec, err := ReadConstField[uint8](ctx, "variableSpec", ReadUnsignedByte(readBuffer, uint8(8)), AlarmMessageObjectAckType_VARIABLESPEC)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'variableSpec' field"))
	}
	_ = variableSpec

	length, err := ReadConstField[uint8](ctx, "length", ReadUnsignedByte(readBuffer, uint8(8)), AlarmMessageObjectAckType_LENGTH)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'length' field"))
	}
	_ = length

	syntaxId, err := ReadEnumField[SyntaxIdType](ctx, "syntaxId", "SyntaxIdType", ReadEnum(SyntaxIdTypeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'syntaxId' field"))
	}
	m.SyntaxId = syntaxId

	numberOfValues, err := ReadSimpleField(ctx, "numberOfValues", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfValues' field"))
	}
	m.NumberOfValues = numberOfValues

	eventId, err := ReadSimpleField(ctx, "eventId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventId' field"))
	}
	m.EventId = eventId

	ackStateGoing, err := ReadSimpleField[State](ctx, "ackStateGoing", ReadComplex[State](StateParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ackStateGoing' field"))
	}
	m.AckStateGoing = ackStateGoing

	ackStateComing, err := ReadSimpleField[State](ctx, "ackStateComing", ReadComplex[State](StateParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ackStateComing' field"))
	}
	m.AckStateComing = ackStateComing

	if closeErr := readBuffer.CloseContext("AlarmMessageObjectAckType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AlarmMessageObjectAckType")
	}

	return m, nil
}

func (m *_AlarmMessageObjectAckType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AlarmMessageObjectAckType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AlarmMessageObjectAckType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AlarmMessageObjectAckType")
	}

	if err := WriteConstField(ctx, "variableSpec", AlarmMessageObjectAckType_VARIABLESPEC, WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'variableSpec' field")
	}

	if err := WriteConstField(ctx, "length", AlarmMessageObjectAckType_LENGTH, WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'length' field")
	}

	if err := WriteSimpleEnumField[SyntaxIdType](ctx, "syntaxId", "SyntaxIdType", m.GetSyntaxId(), WriteEnum[SyntaxIdType, uint8](SyntaxIdType.GetValue, SyntaxIdType.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'syntaxId' field")
	}

	if err := WriteSimpleField[uint8](ctx, "numberOfValues", m.GetNumberOfValues(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'numberOfValues' field")
	}

	if err := WriteSimpleField[uint32](ctx, "eventId", m.GetEventId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventId' field")
	}

	if err := WriteSimpleField[State](ctx, "ackStateGoing", m.GetAckStateGoing(), WriteComplex[State](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'ackStateGoing' field")
	}

	if err := WriteSimpleField[State](ctx, "ackStateComing", m.GetAckStateComing(), WriteComplex[State](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'ackStateComing' field")
	}

	if popErr := writeBuffer.PopContext("AlarmMessageObjectAckType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AlarmMessageObjectAckType")
	}
	return nil
}

func (m *_AlarmMessageObjectAckType) IsAlarmMessageObjectAckType() {}

func (m *_AlarmMessageObjectAckType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AlarmMessageObjectAckType) deepCopy() *_AlarmMessageObjectAckType {
	if m == nil {
		return nil
	}
	_AlarmMessageObjectAckTypeCopy := &_AlarmMessageObjectAckType{
		m.SyntaxId,
		m.NumberOfValues,
		m.EventId,
		utils.DeepCopy[State](m.AckStateGoing),
		utils.DeepCopy[State](m.AckStateComing),
	}
	return _AlarmMessageObjectAckTypeCopy
}

func (m *_AlarmMessageObjectAckType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
