/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonActionResponseMessage is the corresponding interface of JsonActionResponseMessage
type JsonActionResponseMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataSetWriterId returns DataSetWriterId (property field)
	GetDataSetWriterId() uint16
	// GetActionTargetId returns ActionTargetId (property field)
	GetActionTargetId() uint16
	// GetDataSetWriterName returns DataSetWriterName (property field)
	GetDataSetWriterName() PascalString
	// GetWriterGroupName returns WriterGroupName (property field)
	GetWriterGroupName() PascalString
	// GetMetaDataVersion returns MetaDataVersion (property field)
	GetMetaDataVersion() ConfigurationVersionDataType
	// GetMinorVersion returns MinorVersion (property field)
	GetMinorVersion() uint32
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetStatus returns Status (property field)
	GetStatus() StatusCode
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetRequestId returns RequestId (property field)
	GetRequestId() uint16
	// GetActionState returns ActionState (property field)
	GetActionState() ActionState
	// GetPayload returns Payload (property field)
	GetPayload() ExtensionObject
	// IsJsonActionResponseMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonActionResponseMessage()
	// CreateBuilder creates a JsonActionResponseMessageBuilder
	CreateJsonActionResponseMessageBuilder() JsonActionResponseMessageBuilder
}

// _JsonActionResponseMessage is the data-structure of this message
type _JsonActionResponseMessage struct {
	ExtensionObjectDefinitionContract
	DataSetWriterId   uint16
	ActionTargetId    uint16
	DataSetWriterName PascalString
	WriterGroupName   PascalString
	MetaDataVersion   ConfigurationVersionDataType
	MinorVersion      uint32
	Timestamp         int64
	Status            StatusCode
	MessageType       PascalString
	RequestId         uint16
	ActionState       ActionState
	Payload           ExtensionObject
}

var _ JsonActionResponseMessage = (*_JsonActionResponseMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonActionResponseMessage)(nil)

// NewJsonActionResponseMessage factory function for _JsonActionResponseMessage
func NewJsonActionResponseMessage(dataSetWriterId uint16, actionTargetId uint16, dataSetWriterName PascalString, writerGroupName PascalString, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, status StatusCode, messageType PascalString, requestId uint16, actionState ActionState, payload ExtensionObject) *_JsonActionResponseMessage {
	if dataSetWriterName == nil {
		panic("dataSetWriterName of type PascalString for JsonActionResponseMessage must not be nil")
	}
	if writerGroupName == nil {
		panic("writerGroupName of type PascalString for JsonActionResponseMessage must not be nil")
	}
	if metaDataVersion == nil {
		panic("metaDataVersion of type ConfigurationVersionDataType for JsonActionResponseMessage must not be nil")
	}
	if status == nil {
		panic("status of type StatusCode for JsonActionResponseMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonActionResponseMessage must not be nil")
	}
	if payload == nil {
		panic("payload of type ExtensionObject for JsonActionResponseMessage must not be nil")
	}
	_result := &_JsonActionResponseMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataSetWriterId:                   dataSetWriterId,
		ActionTargetId:                    actionTargetId,
		DataSetWriterName:                 dataSetWriterName,
		WriterGroupName:                   writerGroupName,
		MetaDataVersion:                   metaDataVersion,
		MinorVersion:                      minorVersion,
		Timestamp:                         timestamp,
		Status:                            status,
		MessageType:                       messageType,
		RequestId:                         requestId,
		ActionState:                       actionState,
		Payload:                           payload,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonActionResponseMessageBuilder is a builder for JsonActionResponseMessage
type JsonActionResponseMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataSetWriterId uint16, actionTargetId uint16, dataSetWriterName PascalString, writerGroupName PascalString, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, status StatusCode, messageType PascalString, requestId uint16, actionState ActionState, payload ExtensionObject) JsonActionResponseMessageBuilder
	// WithDataSetWriterId adds DataSetWriterId (property field)
	WithDataSetWriterId(uint16) JsonActionResponseMessageBuilder
	// WithActionTargetId adds ActionTargetId (property field)
	WithActionTargetId(uint16) JsonActionResponseMessageBuilder
	// WithDataSetWriterName adds DataSetWriterName (property field)
	WithDataSetWriterName(PascalString) JsonActionResponseMessageBuilder
	// WithDataSetWriterNameBuilder adds DataSetWriterName (property field) which is build by the builder
	WithDataSetWriterNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionResponseMessageBuilder
	// WithWriterGroupName adds WriterGroupName (property field)
	WithWriterGroupName(PascalString) JsonActionResponseMessageBuilder
	// WithWriterGroupNameBuilder adds WriterGroupName (property field) which is build by the builder
	WithWriterGroupNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionResponseMessageBuilder
	// WithMetaDataVersion adds MetaDataVersion (property field)
	WithMetaDataVersion(ConfigurationVersionDataType) JsonActionResponseMessageBuilder
	// WithMetaDataVersionBuilder adds MetaDataVersion (property field) which is build by the builder
	WithMetaDataVersionBuilder(func(ConfigurationVersionDataTypeBuilder) ConfigurationVersionDataTypeBuilder) JsonActionResponseMessageBuilder
	// WithMinorVersion adds MinorVersion (property field)
	WithMinorVersion(uint32) JsonActionResponseMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonActionResponseMessageBuilder
	// WithStatus adds Status (property field)
	WithStatus(StatusCode) JsonActionResponseMessageBuilder
	// WithStatusBuilder adds Status (property field) which is build by the builder
	WithStatusBuilder(func(StatusCodeBuilder) StatusCodeBuilder) JsonActionResponseMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonActionResponseMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionResponseMessageBuilder
	// WithRequestId adds RequestId (property field)
	WithRequestId(uint16) JsonActionResponseMessageBuilder
	// WithActionState adds ActionState (property field)
	WithActionState(ActionState) JsonActionResponseMessageBuilder
	// WithPayload adds Payload (property field)
	WithPayload(ExtensionObject) JsonActionResponseMessageBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) JsonActionResponseMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonActionResponseMessage or returns an error if something is wrong
	Build() (JsonActionResponseMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonActionResponseMessage
}

// NewJsonActionResponseMessageBuilder() creates a JsonActionResponseMessageBuilder
func NewJsonActionResponseMessageBuilder() JsonActionResponseMessageBuilder {
	return &_JsonActionResponseMessageBuilder{_JsonActionResponseMessage: new(_JsonActionResponseMessage)}
}

type _JsonActionResponseMessageBuilder struct {
	*_JsonActionResponseMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (JsonActionResponseMessageBuilder) = (*_JsonActionResponseMessageBuilder)(nil)

func (b *_JsonActionResponseMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonActionResponseMessage
}

func (b *_JsonActionResponseMessageBuilder) WithMandatoryFields(dataSetWriterId uint16, actionTargetId uint16, dataSetWriterName PascalString, writerGroupName PascalString, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, status StatusCode, messageType PascalString, requestId uint16, actionState ActionState, payload ExtensionObject) JsonActionResponseMessageBuilder {
	return b.WithDataSetWriterId(dataSetWriterId).WithActionTargetId(actionTargetId).WithDataSetWriterName(dataSetWriterName).WithWriterGroupName(writerGroupName).WithMetaDataVersion(metaDataVersion).WithMinorVersion(minorVersion).WithTimestamp(timestamp).WithStatus(status).WithMessageType(messageType).WithRequestId(requestId).WithActionState(actionState).WithPayload(payload)
}

func (b *_JsonActionResponseMessageBuilder) WithDataSetWriterId(dataSetWriterId uint16) JsonActionResponseMessageBuilder {
	b.DataSetWriterId = dataSetWriterId
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithActionTargetId(actionTargetId uint16) JsonActionResponseMessageBuilder {
	b.ActionTargetId = actionTargetId
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithDataSetWriterName(dataSetWriterName PascalString) JsonActionResponseMessageBuilder {
	b.DataSetWriterName = dataSetWriterName
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithDataSetWriterNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionResponseMessageBuilder {
	builder := builderSupplier(b.DataSetWriterName.CreatePascalStringBuilder())
	var err error
	b.DataSetWriterName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithWriterGroupName(writerGroupName PascalString) JsonActionResponseMessageBuilder {
	b.WriterGroupName = writerGroupName
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithWriterGroupNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionResponseMessageBuilder {
	builder := builderSupplier(b.WriterGroupName.CreatePascalStringBuilder())
	var err error
	b.WriterGroupName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithMetaDataVersion(metaDataVersion ConfigurationVersionDataType) JsonActionResponseMessageBuilder {
	b.MetaDataVersion = metaDataVersion
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithMetaDataVersionBuilder(builderSupplier func(ConfigurationVersionDataTypeBuilder) ConfigurationVersionDataTypeBuilder) JsonActionResponseMessageBuilder {
	builder := builderSupplier(b.MetaDataVersion.CreateConfigurationVersionDataTypeBuilder())
	var err error
	b.MetaDataVersion, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ConfigurationVersionDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithMinorVersion(minorVersion uint32) JsonActionResponseMessageBuilder {
	b.MinorVersion = minorVersion
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithTimestamp(timestamp int64) JsonActionResponseMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithStatus(status StatusCode) JsonActionResponseMessageBuilder {
	b.Status = status
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithStatusBuilder(builderSupplier func(StatusCodeBuilder) StatusCodeBuilder) JsonActionResponseMessageBuilder {
	builder := builderSupplier(b.Status.CreateStatusCodeBuilder())
	var err error
	b.Status, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "StatusCodeBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithMessageType(messageType PascalString) JsonActionResponseMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionResponseMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithRequestId(requestId uint16) JsonActionResponseMessageBuilder {
	b.RequestId = requestId
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithActionState(actionState ActionState) JsonActionResponseMessageBuilder {
	b.ActionState = actionState
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithPayload(payload ExtensionObject) JsonActionResponseMessageBuilder {
	b.Payload = payload
	return b
}

func (b *_JsonActionResponseMessageBuilder) WithPayloadBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) JsonActionResponseMessageBuilder {
	builder := builderSupplier(b.Payload.CreateExtensionObjectBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponseMessageBuilder) Build() (JsonActionResponseMessage, error) {
	if b.DataSetWriterName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dataSetWriterName' not set"))
	}
	if b.WriterGroupName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'writerGroupName' not set"))
	}
	if b.MetaDataVersion == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'metaDataVersion' not set"))
	}
	if b.Status == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'status' not set"))
	}
	if b.MessageType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageType' not set"))
	}
	if b.Payload == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'payload' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._JsonActionResponseMessage.deepCopy(), nil
}

func (b *_JsonActionResponseMessageBuilder) MustBuild() JsonActionResponseMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonActionResponseMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonActionResponseMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonActionResponseMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonActionResponseMessageBuilder().(*_JsonActionResponseMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateJsonActionResponseMessageBuilder creates a JsonActionResponseMessageBuilder
func (b *_JsonActionResponseMessage) CreateJsonActionResponseMessageBuilder() JsonActionResponseMessageBuilder {
	if b == nil {
		return NewJsonActionResponseMessageBuilder()
	}
	return &_JsonActionResponseMessageBuilder{_JsonActionResponseMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonActionResponseMessage) GetExtensionId() int32 {
	return int32(19324)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonActionResponseMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonActionResponseMessage) GetDataSetWriterId() uint16 {
	return m.DataSetWriterId
}

func (m *_JsonActionResponseMessage) GetActionTargetId() uint16 {
	return m.ActionTargetId
}

func (m *_JsonActionResponseMessage) GetDataSetWriterName() PascalString {
	return m.DataSetWriterName
}

func (m *_JsonActionResponseMessage) GetWriterGroupName() PascalString {
	return m.WriterGroupName
}

func (m *_JsonActionResponseMessage) GetMetaDataVersion() ConfigurationVersionDataType {
	return m.MetaDataVersion
}

func (m *_JsonActionResponseMessage) GetMinorVersion() uint32 {
	return m.MinorVersion
}

func (m *_JsonActionResponseMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonActionResponseMessage) GetStatus() StatusCode {
	return m.Status
}

func (m *_JsonActionResponseMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonActionResponseMessage) GetRequestId() uint16 {
	return m.RequestId
}

func (m *_JsonActionResponseMessage) GetActionState() ActionState {
	return m.ActionState
}

func (m *_JsonActionResponseMessage) GetPayload() ExtensionObject {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonActionResponseMessage(structType any) JsonActionResponseMessage {
	if casted, ok := structType.(JsonActionResponseMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonActionResponseMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonActionResponseMessage) GetTypeName() string {
	return "JsonActionResponseMessage"
}

func (m *_JsonActionResponseMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataSetWriterId)
	lengthInBits += 16

	// Simple field (actionTargetId)
	lengthInBits += 16

	// Simple field (dataSetWriterName)
	lengthInBits += m.DataSetWriterName.GetLengthInBits(ctx)

	// Simple field (writerGroupName)
	lengthInBits += m.WriterGroupName.GetLengthInBits(ctx)

	// Simple field (metaDataVersion)
	lengthInBits += m.MetaDataVersion.GetLengthInBits(ctx)

	// Simple field (minorVersion)
	lengthInBits += 32

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (status)
	lengthInBits += m.Status.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (requestId)
	lengthInBits += 16

	// Simple field (actionState)
	lengthInBits += 32

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_JsonActionResponseMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonActionResponseMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonActionResponseMessage JsonActionResponseMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonActionResponseMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonActionResponseMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataSetWriterId, err := ReadSimpleField(ctx, "dataSetWriterId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterId' field"))
	}
	m.DataSetWriterId = dataSetWriterId

	actionTargetId, err := ReadSimpleField(ctx, "actionTargetId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionTargetId' field"))
	}
	m.ActionTargetId = actionTargetId

	dataSetWriterName, err := ReadSimpleField[PascalString](ctx, "dataSetWriterName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterName' field"))
	}
	m.DataSetWriterName = dataSetWriterName

	writerGroupName, err := ReadSimpleField[PascalString](ctx, "writerGroupName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroupName' field"))
	}
	m.WriterGroupName = writerGroupName

	metaDataVersion, err := ReadSimpleField[ConfigurationVersionDataType](ctx, "metaDataVersion", ReadComplex[ConfigurationVersionDataType](ExtensionObjectDefinitionParseWithBufferProducer[ConfigurationVersionDataType]((int32)(int32(14595))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'metaDataVersion' field"))
	}
	m.MetaDataVersion = metaDataVersion

	minorVersion, err := ReadSimpleField(ctx, "minorVersion", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minorVersion' field"))
	}
	m.MinorVersion = minorVersion

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	status, err := ReadSimpleField[StatusCode](ctx, "status", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'status' field"))
	}
	m.Status = status

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	requestId, err := ReadSimpleField(ctx, "requestId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestId' field"))
	}
	m.RequestId = requestId

	actionState, err := ReadEnumField[ActionState](ctx, "actionState", "ActionState", ReadEnum(ActionStateByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionState' field"))
	}
	m.ActionState = actionState

	payload, err := ReadSimpleField[ExtensionObject](ctx, "payload", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	if closeErr := readBuffer.CloseContext("JsonActionResponseMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonActionResponseMessage")
	}

	return m, nil
}

func (m *_JsonActionResponseMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonActionResponseMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonActionResponseMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonActionResponseMessage")
		}

		if err := WriteSimpleField[uint16](ctx, "dataSetWriterId", m.GetDataSetWriterId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterId' field")
		}

		if err := WriteSimpleField[uint16](ctx, "actionTargetId", m.GetActionTargetId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'actionTargetId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "dataSetWriterName", m.GetDataSetWriterName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "writerGroupName", m.GetWriterGroupName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroupName' field")
		}

		if err := WriteSimpleField[ConfigurationVersionDataType](ctx, "metaDataVersion", m.GetMetaDataVersion(), WriteComplex[ConfigurationVersionDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'metaDataVersion' field")
		}

		if err := WriteSimpleField[uint32](ctx, "minorVersion", m.GetMinorVersion(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'minorVersion' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[StatusCode](ctx, "status", m.GetStatus(), WriteComplex[StatusCode](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'status' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[uint16](ctx, "requestId", m.GetRequestId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestId' field")
		}

		if err := WriteSimpleEnumField[ActionState](ctx, "actionState", "ActionState", m.GetActionState(), WriteEnum[ActionState, uint32](ActionState.GetValue, ActionState.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'actionState' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "payload", m.GetPayload(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("JsonActionResponseMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonActionResponseMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonActionResponseMessage) IsJsonActionResponseMessage() {}

func (m *_JsonActionResponseMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonActionResponseMessage) deepCopy() *_JsonActionResponseMessage {
	if m == nil {
		return nil
	}
	_JsonActionResponseMessageCopy := &_JsonActionResponseMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.DataSetWriterId,
		m.ActionTargetId,
		utils.DeepCopy[PascalString](m.DataSetWriterName),
		utils.DeepCopy[PascalString](m.WriterGroupName),
		utils.DeepCopy[ConfigurationVersionDataType](m.MetaDataVersion),
		m.MinorVersion,
		m.Timestamp,
		utils.DeepCopy[StatusCode](m.Status),
		utils.DeepCopy[PascalString](m.MessageType),
		m.RequestId,
		m.ActionState,
		utils.DeepCopy[ExtensionObject](m.Payload),
	}
	_JsonActionResponseMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonActionResponseMessageCopy
}

func (m *_JsonActionResponseMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
