/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TDataIndividualInd is the corresponding interface of TDataIndividualInd
type TDataIndividualInd interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CEMI
	// IsTDataIndividualInd is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTDataIndividualInd()
	// CreateBuilder creates a TDataIndividualIndBuilder
	CreateTDataIndividualIndBuilder() TDataIndividualIndBuilder
}

// _TDataIndividualInd is the data-structure of this message
type _TDataIndividualInd struct {
	CEMIContract
}

var _ TDataIndividualInd = (*_TDataIndividualInd)(nil)
var _ CEMIRequirements = (*_TDataIndividualInd)(nil)

// NewTDataIndividualInd factory function for _TDataIndividualInd
func NewTDataIndividualInd(size uint16) *_TDataIndividualInd {
	_result := &_TDataIndividualInd{
		CEMIContract: NewCEMI(size),
	}
	_result.CEMIContract.(*_CEMI)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TDataIndividualIndBuilder is a builder for TDataIndividualInd
type TDataIndividualIndBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() TDataIndividualIndBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CEMIBuilder
	// Build builds the TDataIndividualInd or returns an error if something is wrong
	Build() (TDataIndividualInd, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TDataIndividualInd
}

// NewTDataIndividualIndBuilder() creates a TDataIndividualIndBuilder
func NewTDataIndividualIndBuilder() TDataIndividualIndBuilder {
	return &_TDataIndividualIndBuilder{_TDataIndividualInd: new(_TDataIndividualInd)}
}

type _TDataIndividualIndBuilder struct {
	*_TDataIndividualInd

	parentBuilder *_CEMIBuilder

	collectedErr []error
}

var _ (TDataIndividualIndBuilder) = (*_TDataIndividualIndBuilder)(nil)

func (b *_TDataIndividualIndBuilder) setParent(contract CEMIContract) {
	b.CEMIContract = contract
	contract.(*_CEMI)._SubType = b._TDataIndividualInd
}

func (b *_TDataIndividualIndBuilder) WithMandatoryFields() TDataIndividualIndBuilder {
	return b
}

func (b *_TDataIndividualIndBuilder) Build() (TDataIndividualInd, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TDataIndividualInd.deepCopy(), nil
}

func (b *_TDataIndividualIndBuilder) MustBuild() TDataIndividualInd {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TDataIndividualIndBuilder) Done() CEMIBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCEMIBuilder().(*_CEMIBuilder)
	}
	return b.parentBuilder
}

func (b *_TDataIndividualIndBuilder) buildForCEMI() (CEMI, error) {
	return b.Build()
}

func (b *_TDataIndividualIndBuilder) DeepCopy() any {
	_copy := b.CreateTDataIndividualIndBuilder().(*_TDataIndividualIndBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTDataIndividualIndBuilder creates a TDataIndividualIndBuilder
func (b *_TDataIndividualInd) CreateTDataIndividualIndBuilder() TDataIndividualIndBuilder {
	if b == nil {
		return NewTDataIndividualIndBuilder()
	}
	return &_TDataIndividualIndBuilder{_TDataIndividualInd: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_TDataIndividualInd) GetMessageCode() uint8 {
	return 0x94
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TDataIndividualInd) GetParent() CEMIContract {
	return m.CEMIContract
}

// Deprecated: use the interface for direct cast
func CastTDataIndividualInd(structType any) TDataIndividualInd {
	if casted, ok := structType.(TDataIndividualInd); ok {
		return casted
	}
	if casted, ok := structType.(*TDataIndividualInd); ok {
		return *casted
	}
	return nil
}

func (m *_TDataIndividualInd) GetTypeName() string {
	return "TDataIndividualInd"
}

func (m *_TDataIndividualInd) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CEMIContract.(*_CEMI).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_TDataIndividualInd) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TDataIndividualInd) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CEMI, size uint16) (__tDataIndividualInd TDataIndividualInd, err error) {
	m.CEMIContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TDataIndividualInd"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TDataIndividualInd")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TDataIndividualInd"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TDataIndividualInd")
	}

	return m, nil
}

func (m *_TDataIndividualInd) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TDataIndividualInd) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TDataIndividualInd"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TDataIndividualInd")
		}

		if popErr := writeBuffer.PopContext("TDataIndividualInd"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TDataIndividualInd")
		}
		return nil
	}
	return m.CEMIContract.(*_CEMI).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TDataIndividualInd) IsTDataIndividualInd() {}

func (m *_TDataIndividualInd) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TDataIndividualInd) deepCopy() *_TDataIndividualInd {
	if m == nil {
		return nil
	}
	_TDataIndividualIndCopy := &_TDataIndividualInd{
		m.CEMIContract.(*_CEMI).deepCopy(),
	}
	_TDataIndividualIndCopy.CEMIContract.(*_CEMI)._SubType = m
	return _TDataIndividualIndCopy
}

func (m *_TDataIndividualInd) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
