/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataStatusReport1 is the corresponding interface of SecurityDataStatusReport1
type SecurityDataStatusReport1 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// GetArmCodeType returns ArmCodeType (property field)
	GetArmCodeType() SecurityArmCode
	// GetTamperStatus returns TamperStatus (property field)
	GetTamperStatus() TamperStatus
	// GetPanicStatus returns PanicStatus (property field)
	GetPanicStatus() PanicStatus
	// GetZoneStatus returns ZoneStatus (property field)
	GetZoneStatus() []ZoneStatus
	// IsSecurityDataStatusReport1 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataStatusReport1()
	// CreateBuilder creates a SecurityDataStatusReport1Builder
	CreateSecurityDataStatusReport1Builder() SecurityDataStatusReport1Builder
}

// _SecurityDataStatusReport1 is the data-structure of this message
type _SecurityDataStatusReport1 struct {
	SecurityDataContract
	ArmCodeType  SecurityArmCode
	TamperStatus TamperStatus
	PanicStatus  PanicStatus
	ZoneStatus   []ZoneStatus
}

var _ SecurityDataStatusReport1 = (*_SecurityDataStatusReport1)(nil)
var _ SecurityDataRequirements = (*_SecurityDataStatusReport1)(nil)

// NewSecurityDataStatusReport1 factory function for _SecurityDataStatusReport1
func NewSecurityDataStatusReport1(commandTypeContainer SecurityCommandTypeContainer, argument byte, armCodeType SecurityArmCode, tamperStatus TamperStatus, panicStatus PanicStatus, zoneStatus []ZoneStatus) *_SecurityDataStatusReport1 {
	if armCodeType == nil {
		panic("armCodeType of type SecurityArmCode for SecurityDataStatusReport1 must not be nil")
	}
	if tamperStatus == nil {
		panic("tamperStatus of type TamperStatus for SecurityDataStatusReport1 must not be nil")
	}
	if panicStatus == nil {
		panic("panicStatus of type PanicStatus for SecurityDataStatusReport1 must not be nil")
	}
	_result := &_SecurityDataStatusReport1{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
		ArmCodeType:          armCodeType,
		TamperStatus:         tamperStatus,
		PanicStatus:          panicStatus,
		ZoneStatus:           zoneStatus,
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataStatusReport1Builder is a builder for SecurityDataStatusReport1
type SecurityDataStatusReport1Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(armCodeType SecurityArmCode, tamperStatus TamperStatus, panicStatus PanicStatus, zoneStatus []ZoneStatus) SecurityDataStatusReport1Builder
	// WithArmCodeType adds ArmCodeType (property field)
	WithArmCodeType(SecurityArmCode) SecurityDataStatusReport1Builder
	// WithArmCodeTypeBuilder adds ArmCodeType (property field) which is build by the builder
	WithArmCodeTypeBuilder(func(SecurityArmCodeBuilder) SecurityArmCodeBuilder) SecurityDataStatusReport1Builder
	// WithTamperStatus adds TamperStatus (property field)
	WithTamperStatus(TamperStatus) SecurityDataStatusReport1Builder
	// WithTamperStatusBuilder adds TamperStatus (property field) which is build by the builder
	WithTamperStatusBuilder(func(TamperStatusBuilder) TamperStatusBuilder) SecurityDataStatusReport1Builder
	// WithPanicStatus adds PanicStatus (property field)
	WithPanicStatus(PanicStatus) SecurityDataStatusReport1Builder
	// WithPanicStatusBuilder adds PanicStatus (property field) which is build by the builder
	WithPanicStatusBuilder(func(PanicStatusBuilder) PanicStatusBuilder) SecurityDataStatusReport1Builder
	// WithZoneStatus adds ZoneStatus (property field)
	WithZoneStatus(...ZoneStatus) SecurityDataStatusReport1Builder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataStatusReport1 or returns an error if something is wrong
	Build() (SecurityDataStatusReport1, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataStatusReport1
}

// NewSecurityDataStatusReport1Builder() creates a SecurityDataStatusReport1Builder
func NewSecurityDataStatusReport1Builder() SecurityDataStatusReport1Builder {
	return &_SecurityDataStatusReport1Builder{_SecurityDataStatusReport1: new(_SecurityDataStatusReport1)}
}

type _SecurityDataStatusReport1Builder struct {
	*_SecurityDataStatusReport1

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataStatusReport1Builder) = (*_SecurityDataStatusReport1Builder)(nil)

func (b *_SecurityDataStatusReport1Builder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataStatusReport1
}

func (b *_SecurityDataStatusReport1Builder) WithMandatoryFields(armCodeType SecurityArmCode, tamperStatus TamperStatus, panicStatus PanicStatus, zoneStatus []ZoneStatus) SecurityDataStatusReport1Builder {
	return b.WithArmCodeType(armCodeType).WithTamperStatus(tamperStatus).WithPanicStatus(panicStatus).WithZoneStatus(zoneStatus...)
}

func (b *_SecurityDataStatusReport1Builder) WithArmCodeType(armCodeType SecurityArmCode) SecurityDataStatusReport1Builder {
	b.ArmCodeType = armCodeType
	return b
}

func (b *_SecurityDataStatusReport1Builder) WithArmCodeTypeBuilder(builderSupplier func(SecurityArmCodeBuilder) SecurityArmCodeBuilder) SecurityDataStatusReport1Builder {
	builder := builderSupplier(b.ArmCodeType.CreateSecurityArmCodeBuilder())
	var err error
	b.ArmCodeType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "SecurityArmCodeBuilder failed"))
	}
	return b
}

func (b *_SecurityDataStatusReport1Builder) WithTamperStatus(tamperStatus TamperStatus) SecurityDataStatusReport1Builder {
	b.TamperStatus = tamperStatus
	return b
}

func (b *_SecurityDataStatusReport1Builder) WithTamperStatusBuilder(builderSupplier func(TamperStatusBuilder) TamperStatusBuilder) SecurityDataStatusReport1Builder {
	builder := builderSupplier(b.TamperStatus.CreateTamperStatusBuilder())
	var err error
	b.TamperStatus, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "TamperStatusBuilder failed"))
	}
	return b
}

func (b *_SecurityDataStatusReport1Builder) WithPanicStatus(panicStatus PanicStatus) SecurityDataStatusReport1Builder {
	b.PanicStatus = panicStatus
	return b
}

func (b *_SecurityDataStatusReport1Builder) WithPanicStatusBuilder(builderSupplier func(PanicStatusBuilder) PanicStatusBuilder) SecurityDataStatusReport1Builder {
	builder := builderSupplier(b.PanicStatus.CreatePanicStatusBuilder())
	var err error
	b.PanicStatus, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PanicStatusBuilder failed"))
	}
	return b
}

func (b *_SecurityDataStatusReport1Builder) WithZoneStatus(zoneStatus ...ZoneStatus) SecurityDataStatusReport1Builder {
	b.ZoneStatus = zoneStatus
	return b
}

func (b *_SecurityDataStatusReport1Builder) Build() (SecurityDataStatusReport1, error) {
	if b.ArmCodeType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'armCodeType' not set"))
	}
	if b.TamperStatus == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'tamperStatus' not set"))
	}
	if b.PanicStatus == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'panicStatus' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataStatusReport1.deepCopy(), nil
}

func (b *_SecurityDataStatusReport1Builder) MustBuild() SecurityDataStatusReport1 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataStatusReport1Builder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataStatusReport1Builder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataStatusReport1Builder) DeepCopy() any {
	_copy := b.CreateSecurityDataStatusReport1Builder().(*_SecurityDataStatusReport1Builder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataStatusReport1Builder creates a SecurityDataStatusReport1Builder
func (b *_SecurityDataStatusReport1) CreateSecurityDataStatusReport1Builder() SecurityDataStatusReport1Builder {
	if b == nil {
		return NewSecurityDataStatusReport1Builder()
	}
	return &_SecurityDataStatusReport1Builder{_SecurityDataStatusReport1: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataStatusReport1) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SecurityDataStatusReport1) GetArmCodeType() SecurityArmCode {
	return m.ArmCodeType
}

func (m *_SecurityDataStatusReport1) GetTamperStatus() TamperStatus {
	return m.TamperStatus
}

func (m *_SecurityDataStatusReport1) GetPanicStatus() PanicStatus {
	return m.PanicStatus
}

func (m *_SecurityDataStatusReport1) GetZoneStatus() []ZoneStatus {
	return m.ZoneStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSecurityDataStatusReport1(structType any) SecurityDataStatusReport1 {
	if casted, ok := structType.(SecurityDataStatusReport1); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataStatusReport1); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataStatusReport1) GetTypeName() string {
	return "SecurityDataStatusReport1"
}

func (m *_SecurityDataStatusReport1) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	// Simple field (armCodeType)
	lengthInBits += m.ArmCodeType.GetLengthInBits(ctx)

	// Simple field (tamperStatus)
	lengthInBits += m.TamperStatus.GetLengthInBits(ctx)

	// Simple field (panicStatus)
	lengthInBits += m.PanicStatus.GetLengthInBits(ctx)

	// Array field
	if len(m.ZoneStatus) > 0 {
		for _curItem, element := range m.ZoneStatus {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ZoneStatus), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_SecurityDataStatusReport1) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataStatusReport1) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataStatusReport1 SecurityDataStatusReport1, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataStatusReport1"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataStatusReport1")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	armCodeType, err := ReadSimpleField[SecurityArmCode](ctx, "armCodeType", ReadComplex[SecurityArmCode](SecurityArmCodeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'armCodeType' field"))
	}
	m.ArmCodeType = armCodeType

	tamperStatus, err := ReadSimpleField[TamperStatus](ctx, "tamperStatus", ReadComplex[TamperStatus](TamperStatusParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'tamperStatus' field"))
	}
	m.TamperStatus = tamperStatus

	panicStatus, err := ReadSimpleField[PanicStatus](ctx, "panicStatus", ReadComplex[PanicStatus](PanicStatusParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'panicStatus' field"))
	}
	m.PanicStatus = panicStatus

	zoneStatus, err := ReadCountArrayField[ZoneStatus](ctx, "zoneStatus", ReadComplex[ZoneStatus](ZoneStatusParseWithBuffer, readBuffer), uint64(int32(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneStatus' field"))
	}
	m.ZoneStatus = zoneStatus

	if closeErr := readBuffer.CloseContext("SecurityDataStatusReport1"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataStatusReport1")
	}

	return m, nil
}

func (m *_SecurityDataStatusReport1) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataStatusReport1) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataStatusReport1"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataStatusReport1")
		}

		if err := WriteSimpleField[SecurityArmCode](ctx, "armCodeType", m.GetArmCodeType(), WriteComplex[SecurityArmCode](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'armCodeType' field")
		}

		if err := WriteSimpleField[TamperStatus](ctx, "tamperStatus", m.GetTamperStatus(), WriteComplex[TamperStatus](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'tamperStatus' field")
		}

		if err := WriteSimpleField[PanicStatus](ctx, "panicStatus", m.GetPanicStatus(), WriteComplex[PanicStatus](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'panicStatus' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "zoneStatus", m.GetZoneStatus(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneStatus' field")
		}

		if popErr := writeBuffer.PopContext("SecurityDataStatusReport1"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataStatusReport1")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataStatusReport1) IsSecurityDataStatusReport1() {}

func (m *_SecurityDataStatusReport1) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataStatusReport1) deepCopy() *_SecurityDataStatusReport1 {
	if m == nil {
		return nil
	}
	_SecurityDataStatusReport1Copy := &_SecurityDataStatusReport1{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
		utils.DeepCopy[SecurityArmCode](m.ArmCodeType),
		utils.DeepCopy[TamperStatus](m.TamperStatus),
		utils.DeepCopy[PanicStatus](m.PanicStatus),
		utils.DeepCopySlice[ZoneStatus, ZoneStatus](m.ZoneStatus),
	}
	_SecurityDataStatusReport1Copy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataStatusReport1Copy
}

func (m *_SecurityDataStatusReport1) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
