/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataAirConditioning is the corresponding interface of SALDataAirConditioning
type SALDataAirConditioning interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// GetAirConditioningData returns AirConditioningData (property field)
	GetAirConditioningData() AirConditioningData
	// IsSALDataAirConditioning is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataAirConditioning()
	// CreateBuilder creates a SALDataAirConditioningBuilder
	CreateSALDataAirConditioningBuilder() SALDataAirConditioningBuilder
}

// _SALDataAirConditioning is the data-structure of this message
type _SALDataAirConditioning struct {
	SALDataContract
	AirConditioningData AirConditioningData
}

var _ SALDataAirConditioning = (*_SALDataAirConditioning)(nil)
var _ SALDataRequirements = (*_SALDataAirConditioning)(nil)

// NewSALDataAirConditioning factory function for _SALDataAirConditioning
func NewSALDataAirConditioning(salData SALData, airConditioningData AirConditioningData) *_SALDataAirConditioning {
	if airConditioningData == nil {
		panic("airConditioningData of type AirConditioningData for SALDataAirConditioning must not be nil")
	}
	_result := &_SALDataAirConditioning{
		SALDataContract:     NewSALData(salData),
		AirConditioningData: airConditioningData,
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataAirConditioningBuilder is a builder for SALDataAirConditioning
type SALDataAirConditioningBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(airConditioningData AirConditioningData) SALDataAirConditioningBuilder
	// WithAirConditioningData adds AirConditioningData (property field)
	WithAirConditioningData(AirConditioningData) SALDataAirConditioningBuilder
	// WithAirConditioningDataBuilder adds AirConditioningData (property field) which is build by the builder
	WithAirConditioningDataBuilder(func(AirConditioningDataBuilder) AirConditioningDataBuilder) SALDataAirConditioningBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataAirConditioning or returns an error if something is wrong
	Build() (SALDataAirConditioning, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataAirConditioning
}

// NewSALDataAirConditioningBuilder() creates a SALDataAirConditioningBuilder
func NewSALDataAirConditioningBuilder() SALDataAirConditioningBuilder {
	return &_SALDataAirConditioningBuilder{_SALDataAirConditioning: new(_SALDataAirConditioning)}
}

type _SALDataAirConditioningBuilder struct {
	*_SALDataAirConditioning

	parentBuilder *_SALDataBuilder

	collectedErr []error
}

var _ (SALDataAirConditioningBuilder) = (*_SALDataAirConditioningBuilder)(nil)

func (b *_SALDataAirConditioningBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataAirConditioning
}

func (b *_SALDataAirConditioningBuilder) WithMandatoryFields(airConditioningData AirConditioningData) SALDataAirConditioningBuilder {
	return b.WithAirConditioningData(airConditioningData)
}

func (b *_SALDataAirConditioningBuilder) WithAirConditioningData(airConditioningData AirConditioningData) SALDataAirConditioningBuilder {
	b.AirConditioningData = airConditioningData
	return b
}

func (b *_SALDataAirConditioningBuilder) WithAirConditioningDataBuilder(builderSupplier func(AirConditioningDataBuilder) AirConditioningDataBuilder) SALDataAirConditioningBuilder {
	builder := builderSupplier(b.AirConditioningData.CreateAirConditioningDataBuilder())
	var err error
	b.AirConditioningData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "AirConditioningDataBuilder failed"))
	}
	return b
}

func (b *_SALDataAirConditioningBuilder) Build() (SALDataAirConditioning, error) {
	if b.AirConditioningData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'airConditioningData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SALDataAirConditioning.deepCopy(), nil
}

func (b *_SALDataAirConditioningBuilder) MustBuild() SALDataAirConditioning {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataAirConditioningBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataAirConditioningBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataAirConditioningBuilder) DeepCopy() any {
	_copy := b.CreateSALDataAirConditioningBuilder().(*_SALDataAirConditioningBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSALDataAirConditioningBuilder creates a SALDataAirConditioningBuilder
func (b *_SALDataAirConditioning) CreateSALDataAirConditioningBuilder() SALDataAirConditioningBuilder {
	if b == nil {
		return NewSALDataAirConditioningBuilder()
	}
	return &_SALDataAirConditioningBuilder{_SALDataAirConditioning: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataAirConditioning) GetApplicationId() ApplicationId {
	return ApplicationId_AIR_CONDITIONING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataAirConditioning) GetParent() SALDataContract {
	return m.SALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SALDataAirConditioning) GetAirConditioningData() AirConditioningData {
	return m.AirConditioningData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSALDataAirConditioning(structType any) SALDataAirConditioning {
	if casted, ok := structType.(SALDataAirConditioning); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataAirConditioning); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataAirConditioning) GetTypeName() string {
	return "SALDataAirConditioning"
}

func (m *_SALDataAirConditioning) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	// Simple field (airConditioningData)
	lengthInBits += m.AirConditioningData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SALDataAirConditioning) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataAirConditioning) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataAirConditioning SALDataAirConditioning, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataAirConditioning"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataAirConditioning")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	airConditioningData, err := ReadSimpleField[AirConditioningData](ctx, "airConditioningData", ReadComplex[AirConditioningData](AirConditioningDataParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'airConditioningData' field"))
	}
	m.AirConditioningData = airConditioningData

	if closeErr := readBuffer.CloseContext("SALDataAirConditioning"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataAirConditioning")
	}

	return m, nil
}

func (m *_SALDataAirConditioning) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataAirConditioning) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataAirConditioning"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataAirConditioning")
		}

		if err := WriteSimpleField[AirConditioningData](ctx, "airConditioningData", m.GetAirConditioningData(), WriteComplex[AirConditioningData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'airConditioningData' field")
		}

		if popErr := writeBuffer.PopContext("SALDataAirConditioning"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataAirConditioning")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataAirConditioning) IsSALDataAirConditioning() {}

func (m *_SALDataAirConditioning) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataAirConditioning) deepCopy() *_SALDataAirConditioning {
	if m == nil {
		return nil
	}
	_SALDataAirConditioningCopy := &_SALDataAirConditioning{
		m.SALDataContract.(*_SALData).deepCopy(),
		utils.DeepCopy[AirConditioningData](m.AirConditioningData),
	}
	_SALDataAirConditioningCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataAirConditioningCopy
}

func (m *_SALDataAirConditioning) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
