/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AirConditioningDataSetZoneGroupOff is the corresponding interface of AirConditioningDataSetZoneGroupOff
type AirConditioningDataSetZoneGroupOff interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AirConditioningData
	// GetZoneGroup returns ZoneGroup (property field)
	GetZoneGroup() byte
	// IsAirConditioningDataSetZoneGroupOff is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAirConditioningDataSetZoneGroupOff()
	// CreateBuilder creates a AirConditioningDataSetZoneGroupOffBuilder
	CreateAirConditioningDataSetZoneGroupOffBuilder() AirConditioningDataSetZoneGroupOffBuilder
}

// _AirConditioningDataSetZoneGroupOff is the data-structure of this message
type _AirConditioningDataSetZoneGroupOff struct {
	AirConditioningDataContract
	ZoneGroup byte
}

var _ AirConditioningDataSetZoneGroupOff = (*_AirConditioningDataSetZoneGroupOff)(nil)
var _ AirConditioningDataRequirements = (*_AirConditioningDataSetZoneGroupOff)(nil)

// NewAirConditioningDataSetZoneGroupOff factory function for _AirConditioningDataSetZoneGroupOff
func NewAirConditioningDataSetZoneGroupOff(commandTypeContainer AirConditioningCommandTypeContainer, zoneGroup byte) *_AirConditioningDataSetZoneGroupOff {
	_result := &_AirConditioningDataSetZoneGroupOff{
		AirConditioningDataContract: NewAirConditioningData(commandTypeContainer),
		ZoneGroup:                   zoneGroup,
	}
	_result.AirConditioningDataContract.(*_AirConditioningData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AirConditioningDataSetZoneGroupOffBuilder is a builder for AirConditioningDataSetZoneGroupOff
type AirConditioningDataSetZoneGroupOffBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneGroup byte) AirConditioningDataSetZoneGroupOffBuilder
	// WithZoneGroup adds ZoneGroup (property field)
	WithZoneGroup(byte) AirConditioningDataSetZoneGroupOffBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AirConditioningDataBuilder
	// Build builds the AirConditioningDataSetZoneGroupOff or returns an error if something is wrong
	Build() (AirConditioningDataSetZoneGroupOff, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AirConditioningDataSetZoneGroupOff
}

// NewAirConditioningDataSetZoneGroupOffBuilder() creates a AirConditioningDataSetZoneGroupOffBuilder
func NewAirConditioningDataSetZoneGroupOffBuilder() AirConditioningDataSetZoneGroupOffBuilder {
	return &_AirConditioningDataSetZoneGroupOffBuilder{_AirConditioningDataSetZoneGroupOff: new(_AirConditioningDataSetZoneGroupOff)}
}

type _AirConditioningDataSetZoneGroupOffBuilder struct {
	*_AirConditioningDataSetZoneGroupOff

	parentBuilder *_AirConditioningDataBuilder

	collectedErr []error
}

var _ (AirConditioningDataSetZoneGroupOffBuilder) = (*_AirConditioningDataSetZoneGroupOffBuilder)(nil)

func (b *_AirConditioningDataSetZoneGroupOffBuilder) setParent(contract AirConditioningDataContract) {
	b.AirConditioningDataContract = contract
	contract.(*_AirConditioningData)._SubType = b._AirConditioningDataSetZoneGroupOff
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) WithMandatoryFields(zoneGroup byte) AirConditioningDataSetZoneGroupOffBuilder {
	return b.WithZoneGroup(zoneGroup)
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) WithZoneGroup(zoneGroup byte) AirConditioningDataSetZoneGroupOffBuilder {
	b.ZoneGroup = zoneGroup
	return b
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) Build() (AirConditioningDataSetZoneGroupOff, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AirConditioningDataSetZoneGroupOff.deepCopy(), nil
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) MustBuild() AirConditioningDataSetZoneGroupOff {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) Done() AirConditioningDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAirConditioningDataBuilder().(*_AirConditioningDataBuilder)
	}
	return b.parentBuilder
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) buildForAirConditioningData() (AirConditioningData, error) {
	return b.Build()
}

func (b *_AirConditioningDataSetZoneGroupOffBuilder) DeepCopy() any {
	_copy := b.CreateAirConditioningDataSetZoneGroupOffBuilder().(*_AirConditioningDataSetZoneGroupOffBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAirConditioningDataSetZoneGroupOffBuilder creates a AirConditioningDataSetZoneGroupOffBuilder
func (b *_AirConditioningDataSetZoneGroupOff) CreateAirConditioningDataSetZoneGroupOffBuilder() AirConditioningDataSetZoneGroupOffBuilder {
	if b == nil {
		return NewAirConditioningDataSetZoneGroupOffBuilder()
	}
	return &_AirConditioningDataSetZoneGroupOffBuilder{_AirConditioningDataSetZoneGroupOff: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AirConditioningDataSetZoneGroupOff) GetParent() AirConditioningDataContract {
	return m.AirConditioningDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AirConditioningDataSetZoneGroupOff) GetZoneGroup() byte {
	return m.ZoneGroup
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAirConditioningDataSetZoneGroupOff(structType any) AirConditioningDataSetZoneGroupOff {
	if casted, ok := structType.(AirConditioningDataSetZoneGroupOff); ok {
		return casted
	}
	if casted, ok := structType.(*AirConditioningDataSetZoneGroupOff); ok {
		return *casted
	}
	return nil
}

func (m *_AirConditioningDataSetZoneGroupOff) GetTypeName() string {
	return "AirConditioningDataSetZoneGroupOff"
}

func (m *_AirConditioningDataSetZoneGroupOff) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AirConditioningDataContract.(*_AirConditioningData).getLengthInBits(ctx))

	// Simple field (zoneGroup)
	lengthInBits += 8

	return lengthInBits
}

func (m *_AirConditioningDataSetZoneGroupOff) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AirConditioningDataSetZoneGroupOff) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AirConditioningData) (__airConditioningDataSetZoneGroupOff AirConditioningDataSetZoneGroupOff, err error) {
	m.AirConditioningDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AirConditioningDataSetZoneGroupOff"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AirConditioningDataSetZoneGroupOff")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneGroup, err := ReadSimpleField(ctx, "zoneGroup", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneGroup' field"))
	}
	m.ZoneGroup = zoneGroup

	if closeErr := readBuffer.CloseContext("AirConditioningDataSetZoneGroupOff"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AirConditioningDataSetZoneGroupOff")
	}

	return m, nil
}

func (m *_AirConditioningDataSetZoneGroupOff) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AirConditioningDataSetZoneGroupOff) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AirConditioningDataSetZoneGroupOff"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AirConditioningDataSetZoneGroupOff")
		}

		if err := WriteSimpleField[byte](ctx, "zoneGroup", m.GetZoneGroup(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneGroup' field")
		}

		if popErr := writeBuffer.PopContext("AirConditioningDataSetZoneGroupOff"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AirConditioningDataSetZoneGroupOff")
		}
		return nil
	}
	return m.AirConditioningDataContract.(*_AirConditioningData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AirConditioningDataSetZoneGroupOff) IsAirConditioningDataSetZoneGroupOff() {}

func (m *_AirConditioningDataSetZoneGroupOff) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AirConditioningDataSetZoneGroupOff) deepCopy() *_AirConditioningDataSetZoneGroupOff {
	if m == nil {
		return nil
	}
	_AirConditioningDataSetZoneGroupOffCopy := &_AirConditioningDataSetZoneGroupOff{
		m.AirConditioningDataContract.(*_AirConditioningData).deepCopy(),
		m.ZoneGroup,
	}
	_AirConditioningDataSetZoneGroupOffCopy.AirConditioningDataContract.(*_AirConditioningData)._SubType = m
	return _AirConditioningDataSetZoneGroupOffCopy
}

func (m *_AirConditioningDataSetZoneGroupOff) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
