/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventLogRecordLogDatumNotification is the corresponding interface of BACnetEventLogRecordLogDatumNotification
type BACnetEventLogRecordLogDatumNotification interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetEventLogRecordLogDatum
	// GetInnerOpeningTag returns InnerOpeningTag (property field)
	GetInnerOpeningTag() BACnetOpeningTag
	// GetNotification returns Notification (property field)
	GetNotification() ConfirmedEventNotificationRequest
	// GetInnerClosingTag returns InnerClosingTag (property field)
	GetInnerClosingTag() BACnetClosingTag
	// IsBACnetEventLogRecordLogDatumNotification is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventLogRecordLogDatumNotification()
	// CreateBuilder creates a BACnetEventLogRecordLogDatumNotificationBuilder
	CreateBACnetEventLogRecordLogDatumNotificationBuilder() BACnetEventLogRecordLogDatumNotificationBuilder
}

// _BACnetEventLogRecordLogDatumNotification is the data-structure of this message
type _BACnetEventLogRecordLogDatumNotification struct {
	BACnetEventLogRecordLogDatumContract
	InnerOpeningTag BACnetOpeningTag
	Notification    ConfirmedEventNotificationRequest
	InnerClosingTag BACnetClosingTag
}

var _ BACnetEventLogRecordLogDatumNotification = (*_BACnetEventLogRecordLogDatumNotification)(nil)
var _ BACnetEventLogRecordLogDatumRequirements = (*_BACnetEventLogRecordLogDatumNotification)(nil)

// NewBACnetEventLogRecordLogDatumNotification factory function for _BACnetEventLogRecordLogDatumNotification
func NewBACnetEventLogRecordLogDatumNotification(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, innerOpeningTag BACnetOpeningTag, notification ConfirmedEventNotificationRequest, innerClosingTag BACnetClosingTag, tagNumber uint8) *_BACnetEventLogRecordLogDatumNotification {
	if innerOpeningTag == nil {
		panic("innerOpeningTag of type BACnetOpeningTag for BACnetEventLogRecordLogDatumNotification must not be nil")
	}
	if notification == nil {
		panic("notification of type ConfirmedEventNotificationRequest for BACnetEventLogRecordLogDatumNotification must not be nil")
	}
	if innerClosingTag == nil {
		panic("innerClosingTag of type BACnetClosingTag for BACnetEventLogRecordLogDatumNotification must not be nil")
	}
	_result := &_BACnetEventLogRecordLogDatumNotification{
		BACnetEventLogRecordLogDatumContract: NewBACnetEventLogRecordLogDatum(openingTag, peekedTagHeader, closingTag, tagNumber),
		InnerOpeningTag:                      innerOpeningTag,
		Notification:                         notification,
		InnerClosingTag:                      innerClosingTag,
	}
	_result.BACnetEventLogRecordLogDatumContract.(*_BACnetEventLogRecordLogDatum)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventLogRecordLogDatumNotificationBuilder is a builder for BACnetEventLogRecordLogDatumNotification
type BACnetEventLogRecordLogDatumNotificationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(innerOpeningTag BACnetOpeningTag, notification ConfirmedEventNotificationRequest, innerClosingTag BACnetClosingTag) BACnetEventLogRecordLogDatumNotificationBuilder
	// WithInnerOpeningTag adds InnerOpeningTag (property field)
	WithInnerOpeningTag(BACnetOpeningTag) BACnetEventLogRecordLogDatumNotificationBuilder
	// WithInnerOpeningTagBuilder adds InnerOpeningTag (property field) which is build by the builder
	WithInnerOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventLogRecordLogDatumNotificationBuilder
	// WithNotification adds Notification (property field)
	WithNotification(ConfirmedEventNotificationRequest) BACnetEventLogRecordLogDatumNotificationBuilder
	// WithNotificationBuilder adds Notification (property field) which is build by the builder
	WithNotificationBuilder(func(ConfirmedEventNotificationRequestBuilder) ConfirmedEventNotificationRequestBuilder) BACnetEventLogRecordLogDatumNotificationBuilder
	// WithInnerClosingTag adds InnerClosingTag (property field)
	WithInnerClosingTag(BACnetClosingTag) BACnetEventLogRecordLogDatumNotificationBuilder
	// WithInnerClosingTagBuilder adds InnerClosingTag (property field) which is build by the builder
	WithInnerClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventLogRecordLogDatumNotificationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetEventLogRecordLogDatumBuilder
	// Build builds the BACnetEventLogRecordLogDatumNotification or returns an error if something is wrong
	Build() (BACnetEventLogRecordLogDatumNotification, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventLogRecordLogDatumNotification
}

// NewBACnetEventLogRecordLogDatumNotificationBuilder() creates a BACnetEventLogRecordLogDatumNotificationBuilder
func NewBACnetEventLogRecordLogDatumNotificationBuilder() BACnetEventLogRecordLogDatumNotificationBuilder {
	return &_BACnetEventLogRecordLogDatumNotificationBuilder{_BACnetEventLogRecordLogDatumNotification: new(_BACnetEventLogRecordLogDatumNotification)}
}

type _BACnetEventLogRecordLogDatumNotificationBuilder struct {
	*_BACnetEventLogRecordLogDatumNotification

	parentBuilder *_BACnetEventLogRecordLogDatumBuilder

	collectedErr []error
}

var _ (BACnetEventLogRecordLogDatumNotificationBuilder) = (*_BACnetEventLogRecordLogDatumNotificationBuilder)(nil)

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) setParent(contract BACnetEventLogRecordLogDatumContract) {
	b.BACnetEventLogRecordLogDatumContract = contract
	contract.(*_BACnetEventLogRecordLogDatum)._SubType = b._BACnetEventLogRecordLogDatumNotification
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithMandatoryFields(innerOpeningTag BACnetOpeningTag, notification ConfirmedEventNotificationRequest, innerClosingTag BACnetClosingTag) BACnetEventLogRecordLogDatumNotificationBuilder {
	return b.WithInnerOpeningTag(innerOpeningTag).WithNotification(notification).WithInnerClosingTag(innerClosingTag)
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithInnerOpeningTag(innerOpeningTag BACnetOpeningTag) BACnetEventLogRecordLogDatumNotificationBuilder {
	b.InnerOpeningTag = innerOpeningTag
	return b
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithInnerOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetEventLogRecordLogDatumNotificationBuilder {
	builder := builderSupplier(b.InnerOpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.InnerOpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithNotification(notification ConfirmedEventNotificationRequest) BACnetEventLogRecordLogDatumNotificationBuilder {
	b.Notification = notification
	return b
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithNotificationBuilder(builderSupplier func(ConfirmedEventNotificationRequestBuilder) ConfirmedEventNotificationRequestBuilder) BACnetEventLogRecordLogDatumNotificationBuilder {
	builder := builderSupplier(b.Notification.CreateConfirmedEventNotificationRequestBuilder())
	var err error
	b.Notification, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ConfirmedEventNotificationRequestBuilder failed"))
	}
	return b
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithInnerClosingTag(innerClosingTag BACnetClosingTag) BACnetEventLogRecordLogDatumNotificationBuilder {
	b.InnerClosingTag = innerClosingTag
	return b
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) WithInnerClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetEventLogRecordLogDatumNotificationBuilder {
	builder := builderSupplier(b.InnerClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.InnerClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) Build() (BACnetEventLogRecordLogDatumNotification, error) {
	if b.InnerOpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'innerOpeningTag' not set"))
	}
	if b.Notification == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'notification' not set"))
	}
	if b.InnerClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'innerClosingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventLogRecordLogDatumNotification.deepCopy(), nil
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) MustBuild() BACnetEventLogRecordLogDatumNotification {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) Done() BACnetEventLogRecordLogDatumBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetEventLogRecordLogDatumBuilder().(*_BACnetEventLogRecordLogDatumBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) buildForBACnetEventLogRecordLogDatum() (BACnetEventLogRecordLogDatum, error) {
	return b.Build()
}

func (b *_BACnetEventLogRecordLogDatumNotificationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventLogRecordLogDatumNotificationBuilder().(*_BACnetEventLogRecordLogDatumNotificationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventLogRecordLogDatumNotificationBuilder creates a BACnetEventLogRecordLogDatumNotificationBuilder
func (b *_BACnetEventLogRecordLogDatumNotification) CreateBACnetEventLogRecordLogDatumNotificationBuilder() BACnetEventLogRecordLogDatumNotificationBuilder {
	if b == nil {
		return NewBACnetEventLogRecordLogDatumNotificationBuilder()
	}
	return &_BACnetEventLogRecordLogDatumNotificationBuilder{_BACnetEventLogRecordLogDatumNotification: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetEventLogRecordLogDatumNotification) GetParent() BACnetEventLogRecordLogDatumContract {
	return m.BACnetEventLogRecordLogDatumContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventLogRecordLogDatumNotification) GetInnerOpeningTag() BACnetOpeningTag {
	return m.InnerOpeningTag
}

func (m *_BACnetEventLogRecordLogDatumNotification) GetNotification() ConfirmedEventNotificationRequest {
	return m.Notification
}

func (m *_BACnetEventLogRecordLogDatumNotification) GetInnerClosingTag() BACnetClosingTag {
	return m.InnerClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventLogRecordLogDatumNotification(structType any) BACnetEventLogRecordLogDatumNotification {
	if casted, ok := structType.(BACnetEventLogRecordLogDatumNotification); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventLogRecordLogDatumNotification); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventLogRecordLogDatumNotification) GetTypeName() string {
	return "BACnetEventLogRecordLogDatumNotification"
}

func (m *_BACnetEventLogRecordLogDatumNotification) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetEventLogRecordLogDatumContract.(*_BACnetEventLogRecordLogDatum).getLengthInBits(ctx))

	// Simple field (innerOpeningTag)
	lengthInBits += m.InnerOpeningTag.GetLengthInBits(ctx)

	// Simple field (notification)
	lengthInBits += m.Notification.GetLengthInBits(ctx)

	// Simple field (innerClosingTag)
	lengthInBits += m.InnerClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetEventLogRecordLogDatumNotification) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetEventLogRecordLogDatumNotification) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetEventLogRecordLogDatum, tagNumber uint8) (__bACnetEventLogRecordLogDatumNotification BACnetEventLogRecordLogDatumNotification, err error) {
	m.BACnetEventLogRecordLogDatumContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventLogRecordLogDatumNotification"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventLogRecordLogDatumNotification")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	innerOpeningTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerOpeningTag' field"))
	}
	m.InnerOpeningTag = innerOpeningTag

	notification, err := ReadSimpleField[ConfirmedEventNotificationRequest](ctx, "notification", ReadComplex[ConfirmedEventNotificationRequest](ConfirmedEventNotificationRequestParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notification' field"))
	}
	m.Notification = notification

	innerClosingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "innerClosingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerClosingTag' field"))
	}
	m.InnerClosingTag = innerClosingTag

	if closeErr := readBuffer.CloseContext("BACnetEventLogRecordLogDatumNotification"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventLogRecordLogDatumNotification")
	}

	return m, nil
}

func (m *_BACnetEventLogRecordLogDatumNotification) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventLogRecordLogDatumNotification) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetEventLogRecordLogDatumNotification"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetEventLogRecordLogDatumNotification")
		}

		if err := WriteSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", m.GetInnerOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'innerOpeningTag' field")
		}

		if err := WriteSimpleField[ConfirmedEventNotificationRequest](ctx, "notification", m.GetNotification(), WriteComplex[ConfirmedEventNotificationRequest](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'notification' field")
		}

		if err := WriteSimpleField[BACnetClosingTag](ctx, "innerClosingTag", m.GetInnerClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'innerClosingTag' field")
		}

		if popErr := writeBuffer.PopContext("BACnetEventLogRecordLogDatumNotification"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetEventLogRecordLogDatumNotification")
		}
		return nil
	}
	return m.BACnetEventLogRecordLogDatumContract.(*_BACnetEventLogRecordLogDatum).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetEventLogRecordLogDatumNotification) IsBACnetEventLogRecordLogDatumNotification() {}

func (m *_BACnetEventLogRecordLogDatumNotification) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventLogRecordLogDatumNotification) deepCopy() *_BACnetEventLogRecordLogDatumNotification {
	if m == nil {
		return nil
	}
	_BACnetEventLogRecordLogDatumNotificationCopy := &_BACnetEventLogRecordLogDatumNotification{
		m.BACnetEventLogRecordLogDatumContract.(*_BACnetEventLogRecordLogDatum).deepCopy(),
		utils.DeepCopy[BACnetOpeningTag](m.InnerOpeningTag),
		utils.DeepCopy[ConfirmedEventNotificationRequest](m.Notification),
		utils.DeepCopy[BACnetClosingTag](m.InnerClosingTag),
	}
	_BACnetEventLogRecordLogDatumNotificationCopy.BACnetEventLogRecordLogDatumContract.(*_BACnetEventLogRecordLogDatum)._SubType = m
	return _BACnetEventLogRecordLogDatumNotificationCopy
}

func (m *_BACnetEventLogRecordLogDatumNotification) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
