/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataRoutingTable is the corresponding interface of BACnetConstructedDataRoutingTable
type BACnetConstructedDataRoutingTable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetRoutingTable returns RoutingTable (property field)
	GetRoutingTable() []BACnetRouterEntry
	// IsBACnetConstructedDataRoutingTable is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataRoutingTable()
	// CreateBuilder creates a BACnetConstructedDataRoutingTableBuilder
	CreateBACnetConstructedDataRoutingTableBuilder() BACnetConstructedDataRoutingTableBuilder
}

// _BACnetConstructedDataRoutingTable is the data-structure of this message
type _BACnetConstructedDataRoutingTable struct {
	BACnetConstructedDataContract
	RoutingTable []BACnetRouterEntry
}

var _ BACnetConstructedDataRoutingTable = (*_BACnetConstructedDataRoutingTable)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataRoutingTable)(nil)

// NewBACnetConstructedDataRoutingTable factory function for _BACnetConstructedDataRoutingTable
func NewBACnetConstructedDataRoutingTable(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, routingTable []BACnetRouterEntry, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataRoutingTable {
	_result := &_BACnetConstructedDataRoutingTable{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		RoutingTable:                  routingTable,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataRoutingTableBuilder is a builder for BACnetConstructedDataRoutingTable
type BACnetConstructedDataRoutingTableBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(routingTable []BACnetRouterEntry) BACnetConstructedDataRoutingTableBuilder
	// WithRoutingTable adds RoutingTable (property field)
	WithRoutingTable(...BACnetRouterEntry) BACnetConstructedDataRoutingTableBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataRoutingTable or returns an error if something is wrong
	Build() (BACnetConstructedDataRoutingTable, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataRoutingTable
}

// NewBACnetConstructedDataRoutingTableBuilder() creates a BACnetConstructedDataRoutingTableBuilder
func NewBACnetConstructedDataRoutingTableBuilder() BACnetConstructedDataRoutingTableBuilder {
	return &_BACnetConstructedDataRoutingTableBuilder{_BACnetConstructedDataRoutingTable: new(_BACnetConstructedDataRoutingTable)}
}

type _BACnetConstructedDataRoutingTableBuilder struct {
	*_BACnetConstructedDataRoutingTable

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataRoutingTableBuilder) = (*_BACnetConstructedDataRoutingTableBuilder)(nil)

func (b *_BACnetConstructedDataRoutingTableBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataRoutingTable
}

func (b *_BACnetConstructedDataRoutingTableBuilder) WithMandatoryFields(routingTable []BACnetRouterEntry) BACnetConstructedDataRoutingTableBuilder {
	return b.WithRoutingTable(routingTable...)
}

func (b *_BACnetConstructedDataRoutingTableBuilder) WithRoutingTable(routingTable ...BACnetRouterEntry) BACnetConstructedDataRoutingTableBuilder {
	b.RoutingTable = routingTable
	return b
}

func (b *_BACnetConstructedDataRoutingTableBuilder) Build() (BACnetConstructedDataRoutingTable, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataRoutingTable.deepCopy(), nil
}

func (b *_BACnetConstructedDataRoutingTableBuilder) MustBuild() BACnetConstructedDataRoutingTable {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataRoutingTableBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataRoutingTableBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataRoutingTableBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataRoutingTableBuilder().(*_BACnetConstructedDataRoutingTableBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataRoutingTableBuilder creates a BACnetConstructedDataRoutingTableBuilder
func (b *_BACnetConstructedDataRoutingTable) CreateBACnetConstructedDataRoutingTableBuilder() BACnetConstructedDataRoutingTableBuilder {
	if b == nil {
		return NewBACnetConstructedDataRoutingTableBuilder()
	}
	return &_BACnetConstructedDataRoutingTableBuilder{_BACnetConstructedDataRoutingTable: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataRoutingTable) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataRoutingTable) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ROUTING_TABLE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataRoutingTable) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataRoutingTable) GetRoutingTable() []BACnetRouterEntry {
	return m.RoutingTable
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataRoutingTable(structType any) BACnetConstructedDataRoutingTable {
	if casted, ok := structType.(BACnetConstructedDataRoutingTable); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataRoutingTable); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataRoutingTable) GetTypeName() string {
	return "BACnetConstructedDataRoutingTable"
}

func (m *_BACnetConstructedDataRoutingTable) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.RoutingTable) > 0 {
		for _, element := range m.RoutingTable {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataRoutingTable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataRoutingTable) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataRoutingTable BACnetConstructedDataRoutingTable, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataRoutingTable"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataRoutingTable")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	routingTable, err := ReadTerminatedArrayField[BACnetRouterEntry](ctx, "routingTable", ReadComplex[BACnetRouterEntry](BACnetRouterEntryParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'routingTable' field"))
	}
	m.RoutingTable = routingTable

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataRoutingTable"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataRoutingTable")
	}

	return m, nil
}

func (m *_BACnetConstructedDataRoutingTable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataRoutingTable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataRoutingTable"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataRoutingTable")
		}

		if err := WriteComplexTypeArrayField(ctx, "routingTable", m.GetRoutingTable(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'routingTable' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataRoutingTable"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataRoutingTable")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataRoutingTable) IsBACnetConstructedDataRoutingTable() {}

func (m *_BACnetConstructedDataRoutingTable) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataRoutingTable) deepCopy() *_BACnetConstructedDataRoutingTable {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataRoutingTableCopy := &_BACnetConstructedDataRoutingTable{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetRouterEntry, BACnetRouterEntry](m.RoutingTable),
	}
	_BACnetConstructedDataRoutingTableCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataRoutingTableCopy
}

func (m *_BACnetConstructedDataRoutingTable) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
