/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.time;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class SimpleTimer {
    private static SimpleTimer instance;
    private Timer timer = new Timer("SimpleTimer", true);

    public static synchronized SimpleTimer getInstance() {
        if (instance == null) {
            instance = new SimpleTimer();
        }
        return instance;
    }

    private SimpleTimer() {
    }

    public void schedule(Runnable task, long delay) {
        this.timer.schedule((TimerTask)new LoggingTimerTask(task), delay);
    }

    public void schedule(Runnable task, long delay, long period) {
        this.timer.schedule((TimerTask)new LoggingTimerTask(task), delay, period);
    }

    static class LoggingTimerTask
    extends TimerTask {
        private Runnable task;

        LoggingTimerTask(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable t) {
                Logger.getLogger(LoggingTimerTask.class).warn((Object)("Timer task failed " + this.task.getClass().getName() + " " + t.getMessage()), t);
            }
        }
    }
}

