/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.servlets.trace;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.trace.TraceFormatter;
import org.apache.accumulo.server.monitor.servlets.trace.Basic;
import org.apache.accumulo.server.monitor.servlets.trace.ShowTraceLinkType;
import org.apache.accumulo.server.monitor.util.Table;
import org.apache.accumulo.server.monitor.util.celltypes.DurationType;
import org.apache.accumulo.server.monitor.util.celltypes.StringType;
import org.apache.accumulo.trace.thrift.RemoteSpan;
import org.apache.hadoop.io.Text;

public class ListType
extends Basic {
    private static final long serialVersionUID = 1L;

    String getType(HttpServletRequest req) {
        return ListType.getStringParameter(req, "type", "<Unknown>");
    }

    int getMinutes(HttpServletRequest req) {
        return ListType.getIntParameter(req, "minutes", 10);
    }

    @Override
    public void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) throws Exception {
        String type = this.getType(req);
        int minutes = this.getMinutes(req);
        long endTime = System.currentTimeMillis();
        long startTime = endTime - (long)(minutes * 60 * 1000);
        Scanner scanner = this.getScanner(sb);
        if (scanner == null) {
            return;
        }
        Range range = new Range(new Text("start:" + Long.toHexString(startTime)), new Text("start:" + Long.toHexString(endTime)));
        scanner.setRange(range);
        Table trace = new Table("trace", "Traces for " + this.getType(req));
        trace.addSortableColumn("Start", new ShowTraceLinkType(), "Start Time");
        trace.addSortableColumn("ms", new DurationType(), "Span time");
        trace.addUnsortableColumn("Source", new StringType(), "Service and location");
        for (Map.Entry entry : scanner) {
            RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
            if (!span.description.equals(type)) continue;
            trace.addRow(span, new Long(span.stop - span.start), span.svc + ":" + span.sender);
        }
        trace.generate(req, sb);
    }

    @Override
    public String getTitle(HttpServletRequest req) {
        return "Traces for " + this.getType(req) + " for the last " + this.getMinutes(req) + " minutes";
    }
}

