/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metanalysis;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.logger.LogEvents;
import org.apache.accumulo.server.logger.LogFileKey;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.accumulo.server.metanalysis.LogFileInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class IndexMeta
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(IndexMeta.class.getName(), args, new Object[0]);
        String jobName = ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis();
        Job job = new Job(this.getConf(), jobName);
        job.setJarByClass(((Object)((Object)this)).getClass());
        List<String> logFiles = Arrays.asList(args).subList(4, args.length);
        Path[] paths = new Path[logFiles.size()];
        int count = 0;
        for (String logFile : logFiles) {
            paths[count++] = new Path(logFile);
        }
        job.setInputFormatClass(LogFileInputFormat.class);
        LogFileInputFormat.setInputPaths((Job)job, (Path[])paths);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setZooKeeperInstance((Job)job, (String)opts.instance, (String)opts.zookeepers);
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)opts.principal, (AuthenticationToken)opts.getToken());
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)false);
        job.setMapperClass(IndexMapper.class);
        Connector conn = opts.getConnector();
        try {
            conn.tableOperations().create("createEvents");
        }
        catch (TableExistsException tee) {
            Logger.getLogger(IndexMeta.class).warn((Object)"Table createEvents exists");
        }
        try {
            conn.tableOperations().create("tabletEvents");
        }
        catch (TableExistsException tee) {
            Logger.getLogger(IndexMeta.class).warn((Object)"Table tabletEvents exists");
        }
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new IndexMeta(), (String[])args);
        System.exit(res);
    }

    static class Opts
    extends ClientOpts {
        @Parameter(description="<logfile> { <logfile> ...}")
        List<String> logFiles = new ArrayList<String>();

        Opts() {
        }
    }

    public static class IndexMapper
    extends Mapper<LogFileKey, LogFileValue, Text, Mutation> {
        private static final Text CREATE_EVENTS_TABLE = new Text("createEvents");
        private static final Text TABLET_EVENTS_TABLE = new Text("tabletEvents");
        private Map<Integer, KeyExtent> tabletIds = new HashMap<Integer, KeyExtent>();
        private String uuid = null;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.tabletIds = new HashMap<Integer, KeyExtent>();
            this.uuid = null;
        }

        public void map(LogFileKey key, LogFileValue value, Mapper.Context context) throws IOException, InterruptedException {
            if (key.event == LogEvents.OPEN) {
                this.uuid = key.tserverSession;
            } else if (key.event == LogEvents.DEFINE_TABLET) {
                if (key.tablet.getTableId().toString().equals("!0")) {
                    this.tabletIds.put(key.tid, new KeyExtent(key.tablet));
                }
            } else if ((key.event == LogEvents.MUTATION || key.event == LogEvents.MANY_MUTATIONS) && this.tabletIds.containsKey(key.tid)) {
                for (Mutation m : value.mutations) {
                    this.index(context, m, this.uuid, this.tabletIds.get(key.tid));
                }
            }
        }

        void index(Mapper.Context context, Mutation m, String logFile, KeyExtent metaTablet) throws IOException, InterruptedException {
            List columnsUpdates = m.getUpdates();
            Text prevRow = null;
            long timestamp = 0L;
            if (m.getRow().length > 0 && m.getRow()[0] == 126) {
                return;
            }
            for (ColumnUpdate cu : columnsUpdates) {
                if (Constants.METADATA_PREV_ROW_COLUMN.equals(new Text(cu.getColumnFamily()), new Text(cu.getColumnQualifier())) && !cu.isDeleted()) {
                    prevRow = new Text(cu.getValue());
                }
                timestamp = cu.getTimestamp();
            }
            byte[] serMut = WritableUtils.toByteArray((Writable[])new Writable[]{m});
            if (prevRow != null) {
                Mutation createEvent = new Mutation(new Text(m.getRow()));
                createEvent.put(prevRow, new Text(String.format("%020d", timestamp)), new Value(metaTablet.toString().getBytes()));
                context.write((Object)CREATE_EVENTS_TABLE, (Object)createEvent);
            }
            Mutation tabletEvent = new Mutation(new Text(m.getRow()));
            tabletEvent.put(new Text(String.format("%020d", timestamp)), new Text("mut"), new Value(serMut));
            tabletEvent.put(new Text(String.format("%020d", timestamp)), new Text("mtab"), new Value(metaTablet.toString().getBytes()));
            tabletEvent.put(new Text(String.format("%020d", timestamp)), new Text("log"), new Value(logFile.getBytes()));
            context.write((Object)TABLET_EVENTS_TABLE, (Object)tabletEvent);
        }
    }
}

