/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.tableOps.MakeDeleteEntries;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.hadoop.io.Text;

class TableRangeOpWait
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;

    public TableRangeOpWait(String tableId) {
        this.tableId = tableId;
    }

    @Override
    public long isReady(long tid, Master env) throws Exception {
        Text tableIdText = new Text(this.tableId);
        if (!env.getMergeInfo(tableIdText).getState().equals((Object)MergeState.NONE)) {
            return 50L;
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Text tableIdText = new Text(this.tableId);
        MergeInfo mergeInfo = master.getMergeInfo(tableIdText);
        log.info((Object)("removing merge information " + mergeInfo));
        master.clearMergeState(tableIdText);
        Utils.unreserveTable(this.tableId, tid, true);
        if (mergeInfo.getOperation().equals((Object)MergeInfo.Operation.MERGE) && this.tableId.equals("!0")) {
            return new MakeDeleteEntries();
        }
        return null;
    }
}

