/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.LoadFiles;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;
import org.apache.accumulo.server.tabletserver.UniqueNameAllocator;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class BulkImport
extends MasterRepo {
    public static final String FAILURES_TXT = "failures.txt";
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(BulkImport.class);
    private String tableId;
    private String sourceDir;
    private String errorDir;
    private boolean setTime;

    public BulkImport(String tableId, String sourceDir, String errorDir, boolean setTime) {
        this.tableId = tableId;
        this.sourceDir = sourceDir;
        this.errorDir = errorDir;
        this.setTime = setTime;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (!Utils.getReadLock(this.tableId, tid).tryLock()) {
            return 100L;
        }
        Instance instance = HdfsZooInstance.getInstance();
        Tables.clearCache((Instance)instance);
        if (Tables.getTableState((Instance)instance, (String)this.tableId) == TableState.ONLINE) {
            long reserve2 = Utils.reserveHdfsDirectory(this.sourceDir, tid);
            long reserve1 = reserve2;
            if (reserve1 == 0L) {
                reserve2 = Utils.reserveHdfsDirectory(this.errorDir, tid);
            }
            return reserve2;
        }
        throw new ThriftTableOperationException(this.tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.OFFLINE, null);
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        log.debug((Object)(" tid " + tid + " sourceDir " + this.sourceDir));
        Utils.getReadLock(this.tableId, tid).lock();
        FileSystem fs = master.getFileSystem();
        Path errorPath = new Path(this.errorDir);
        FileStatus errorStatus = null;
        try {
            errorStatus = fs.getFileStatus(errorPath);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (errorStatus == null) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_ERROR_DIRECTORY, this.errorDir + " does not exist");
        }
        if (!errorStatus.isDir()) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_ERROR_DIRECTORY, this.errorDir + " is not a directory");
        }
        if (fs.listStatus(errorPath).length != 0) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_ERROR_DIRECTORY, this.errorDir + " is not empty");
        }
        TransactionWatcher.ZooArbitrator.start("bulkTx", tid);
        try {
            String bulkDir = this.prepareBulkImport(fs, this.sourceDir, this.tableId);
            log.debug((Object)(" tid " + tid + " bulkDir " + bulkDir));
            return new LoadFiles(this.tableId, this.sourceDir, bulkDir, this.errorDir, this.setTime);
        }
        catch (IOException ex) {
            log.error((Object)"error preparing the bulk import directory", (Throwable)ex);
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.BULK_IMPORT, TableOperationExceptionType.BULK_BAD_INPUT_DIRECTORY, this.sourceDir + ": " + ex);
        }
    }

    private Path createNewBulkDir(FileSystem fs, String tableId) throws IOException {
        Path directory = new Path(ServerConstants.getTablesDir() + "/" + tableId);
        fs.mkdirs(directory);
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        while (true) {
            Path newBulkDir;
            if (fs.exists(newBulkDir = new Path(directory, "b-" + namer.getNextName()))) {
                throw new IllegalStateException("Dir exist when it should not " + newBulkDir);
            }
            if (fs.mkdirs(newBulkDir)) {
                return newBulkDir;
            }
            log.warn((Object)("Failed to create " + newBulkDir + " for unknown reason"));
            UtilWaitThread.sleep((long)3000L);
        }
    }

    private String prepareBulkImport(FileSystem fs, String dir, String tableId) throws IOException {
        Path bulkDir = this.createNewBulkDir(fs, tableId);
        MetadataTable.addBulkLoadInProgressFlag("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName());
        Path dirPath = new Path(dir);
        FileStatus[] mapFiles = fs.listStatus(dirPath);
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        for (FileStatus fileStatus : mapFiles) {
            String extension;
            block12: {
                String[] sa = fileStatus.getPath().getName().split("\\.");
                extension = "";
                if (sa.length > 1) {
                    extension = sa[sa.length - 1];
                    if (!FileOperations.getValidExtensions().contains(extension)) {
                        log.warn((Object)(fileStatus.getPath() + " does not have a valid extension, ignoring"));
                        continue;
                    }
                } else {
                    extension = "map";
                }
                if (extension.equals("map")) {
                    if (!fileStatus.isDir()) {
                        log.warn((Object)(fileStatus.getPath() + " is not a map file, ignoring"));
                        continue;
                    }
                    if (fileStatus.getPath().getName().equals("_logs")) {
                        log.info((Object)(fileStatus.getPath() + " is probably a log directory from a map/reduce task, skipping"));
                        continue;
                    }
                    try {
                        FileStatus dataStatus = fs.getFileStatus(new Path(fileStatus.getPath(), "data"));
                        if (dataStatus.isDir()) {
                            log.warn((Object)(fileStatus.getPath() + " is not a map file, ignoring"));
                        }
                        break block12;
                    }
                    catch (FileNotFoundException fnfe) {
                        log.warn((Object)(fileStatus.getPath() + " is not a map file, ignoring"));
                    }
                    continue;
                }
            }
            String newName = "I" + namer.getNextName() + "." + extension;
            Path newPath = new Path(bulkDir, newName);
            try {
                fs.rename(fileStatus.getPath(), newPath);
                log.debug((Object)("Moved " + fileStatus.getPath() + " to " + newPath));
            }
            catch (IOException E1) {
                log.error((Object)("Could not move: " + fileStatus.getPath().toString() + " " + E1.getMessage()));
            }
        }
        return bulkDir.toString();
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Utils.unreserveHdfsDirectory(this.sourceDir, tid);
        Utils.unreserveHdfsDirectory(this.errorDir, tid);
        Utils.getReadLock(this.tableId, tid).unlock();
    }
}

