/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezTaskAttemptID
extends TezID {
    public static final String ATTEMPT = "attempt";
    private TezTaskID taskId;
    private static TezID.TezIDCache<TezTaskAttemptID> tezTaskAttemptIDCache = new TezID.TezIDCache();

    public TezTaskAttemptID() {
    }

    public static TezTaskAttemptID getInstance(TezTaskID taskID, int id) {
        return tezTaskAttemptIDCache.getInstance(new TezTaskAttemptID(taskID, id));
    }

    @InterfaceAudience.Private
    public static void clearCache() {
        tezTaskAttemptIDCache.clear();
    }

    private TezTaskAttemptID(TezTaskID taskId, int id) {
        super(id);
        if (taskId == null) {
            throw new IllegalArgumentException("taskId cannot be null");
        }
        this.taskId = taskId;
    }

    public TezTaskID getTaskID() {
        return this.taskId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezTaskAttemptID that = (TezTaskAttemptID)o;
        return this.taskId.equals(that.taskId);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        this.taskId.appendTo(builder);
        builder.append('_');
        return builder.append(this.id);
    }

    @Override
    public int hashCode() {
        return this.taskId.hashCode() * 539501 + this.id;
    }

    @Override
    public int compareTo(TezID o) {
        TezTaskAttemptID that = (TezTaskAttemptID)o;
        int tipComp = this.taskId.compareTo(that.taskId);
        if (tipComp == 0) {
            return this.id - that.id;
        }
        return tipComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(ATTEMPT)).toString();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.taskId = TezTaskID.readTezTaskID(in);
        super.readFields(in);
    }

    public static TezTaskAttemptID readTezTaskAttemptID(DataInput in) throws IOException {
        TezTaskID taskID = TezTaskID.readTezTaskID(in);
        int attemptIdInt = TezID.readID(in);
        return TezTaskAttemptID.getInstance(taskID, attemptIdInt);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.taskId.write(out);
        super.write(out);
    }

    public static TezTaskAttemptID fromString(String taIdStr) {
        try {
            int pos1 = taIdStr.indexOf(95);
            int pos2 = taIdStr.indexOf(95, pos1 + 1);
            int pos3 = taIdStr.indexOf(95, pos2 + 1);
            int pos4 = taIdStr.indexOf(95, pos3 + 1);
            int pos5 = taIdStr.indexOf(95, pos4 + 1);
            int pos6 = taIdStr.indexOf(95, pos5 + 1);
            String rmId = taIdStr.substring(pos1 + 1, pos2);
            int appId = Integer.parseInt(taIdStr.substring(pos2 + 1, pos3));
            int dagId = Integer.parseInt(taIdStr.substring(pos3 + 1, pos4));
            int vId = Integer.parseInt(taIdStr.substring(pos4 + 1, pos5));
            int taskId = Integer.parseInt(taIdStr.substring(pos5 + 1, pos6));
            int id = Integer.parseInt(taIdStr.substring(pos6 + 1));
            return TezTaskAttemptID.getInstance(TezTaskID.getInstance(TezVertexID.getInstance(TezDAGID.getInstance(rmId, appId, dagId), vId), taskId), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

