/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.RowProcessorProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RowProcessor;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public abstract class BaseRowProcessorEndpoint<S extends Message, T extends Message>
extends RowProcessorProtos.RowProcessorService
implements CoprocessorService,
Coprocessor {
    private RegionCoprocessorEnvironment env;

    public void process(RpcController controller, RowProcessorProtos.ProcessRequest request, RpcCallback<RowProcessorProtos.ProcessResponse> done) {
        RowProcessorProtos.ProcessResponse resultProto = null;
        try {
            RowProcessor<S, T> processor = this.constructRowProcessorFromRequest(request);
            Region region = this.env.getRegion();
            long nonceGroup = request.hasNonceGroup() ? request.getNonceGroup() : 0L;
            long nonce = request.hasNonce() ? request.getNonce() : 0L;
            region.processRowsWithLocks(processor, nonceGroup, nonce);
            T result = processor.getResult();
            RowProcessorProtos.ProcessResponse.Builder b = RowProcessorProtos.ProcessResponse.newBuilder();
            b.setRowProcessorResult(result.toByteString());
            resultProto = b.build();
        }
        catch (Exception e) {
            ResponseConverter.setControllerException((RpcController)controller, (IOException)new IOException(e));
        }
        done.run(resultProto);
    }

    @Override
    public Service getService() {
        return this;
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    RowProcessor<S, T> constructRowProcessorFromRequest(RowProcessorProtos.ProcessRequest request) throws IOException {
        String className = request.getRowProcessorClassName();
        try {
            Class<?> cls = Class.forName(className);
            RowProcessor ci = (RowProcessor)cls.newInstance();
            if (request.hasRowProcessorInitializerMessageName()) {
                Message s;
                Method m;
                Class<Message> imn = Class.forName(request.getRowProcessorInitializerMessageName()).asSubclass(Message.class);
                try {
                    m = imn.getMethod("parseFrom", ByteString.class);
                }
                catch (SecurityException e) {
                    throw new IOException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e);
                }
                try {
                    s = (Message)m.invoke(null, request.getRowProcessorInitializerMessage());
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IOException(e);
                }
                ci.initialize(s);
            }
            return ci;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }
}

