/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class SimpleMutableByteRange
extends AbstractByteRange {
    public SimpleMutableByteRange() {
        this.unset();
    }

    public SimpleMutableByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimpleMutableByteRange(byte[] bytes) {
        this.set(bytes);
    }

    public SimpleMutableByteRange(byte[] bytes, int offset, int length) {
        this.set(bytes, offset, length);
    }

    @Override
    public ByteRange unset() {
        this.clearHashCache();
        this.bytes = null;
        this.offset = 0;
        this.length = 0;
        return this;
    }

    @Override
    public ByteRange put(int index, byte val) {
        this.bytes[this.offset + index] = val;
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange put(int index, byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(index, val, 0, val.length);
    }

    @Override
    public ByteRange put(int index, byte[] val, int offset, int length) {
        if (0 == length) {
            return this;
        }
        System.arraycopy(val, offset, this.bytes, this.offset + index, length);
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange putShort(int index, short val) {
        this.bytes[this.offset + index + 1] = (byte)val;
        val = (short)(val >> 8);
        this.bytes[this.offset + index] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange putInt(int index, int val) {
        for (int i = 3; i > 0; --i) {
            this.bytes[this.offset + index + i] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public ByteRange putLong(int index, long val) {
        for (int i = 7; i > 0; --i) {
            this.bytes[this.offset + index + i] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public int putVLong(int index, long val) {
        int rPos = 0;
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.bytes[this.offset + index + rPos] = (byte)(val & 0x7FL | 0x80L);
            val >>>= 7;
            ++rPos;
        }
        this.bytes[this.offset + index + rPos] = (byte)val;
        this.clearHashCache();
        return rPos + 1;
    }

    @Override
    public ByteRange deepCopy() {
        SimpleMutableByteRange clone = new SimpleMutableByteRange(this.deepCopyToNewArray());
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopy() {
        SimpleMutableByteRange clone = new SimpleMutableByteRange(this.bytes, this.offset, this.length);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimpleMutableByteRange clone = new SimpleMutableByteRange(this.bytes, this.offset + innerOffset, copyLength);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    public boolean equals(Object thatObject) {
        if (thatObject == null) {
            return false;
        }
        if (this == thatObject) {
            return true;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        if (!(thatObject instanceof SimpleMutableByteRange)) {
            return false;
        }
        SimpleMutableByteRange that = (SimpleMutableByteRange)thatObject;
        return Bytes.equals(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }
}

