/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapreduce.TestTableInputFormatScanBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableInputFormatScan1
extends TestTableInputFormatScanBase {
    @Test
    public void testScanEmptyToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, null, null);
    }

    @Test
    public void testScanEmptyToAPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "app", "apo");
    }

    @Test
    public void testScanEmptyToBBA() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "bba", "baz");
    }

    @Test
    public void testScanEmptyToBBB() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "bbb", "bba");
    }

    @Test
    public void testScanEmptyToOPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "opp", "opo");
    }

    @Test
    public void testGetSplits() throws IOException, InterruptedException, ClassNotFoundException {
        HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLE_NAME);
        List locs = table.getRegionLocator().getAllRegionLocations();
        this.testNumOfSplits("-1", locs.size() * 2);
        table.close();
        this.testNumOfSplits("100", 1);
    }

    @Test
    public void testGetSplitsPoint() throws IOException, InterruptedException, ClassNotFoundException {
        byte[] start1 = new byte[]{97, 97, 97, 98, 99, 100, 101, 102};
        byte[] end1 = new byte[]{97, 97, 97, 102, 102};
        byte[] splitPoint1 = new byte[]{97, 97, 97, 100};
        this.testGetSplitKey(start1, end1, splitPoint1, true);
        byte[] start2 = new byte[]{49, 49, 49, 48, 48, 48};
        byte[] end2 = new byte[]{49, 49, 50, 53, 55, 57, 48};
        byte[] splitPoint2 = new byte[]{49, 49, 49, 98};
        this.testGetSplitKey(start2, end2, splitPoint2, true);
        byte[] start3 = new byte[]{97, 97, 97, 97, 97, 97};
        byte[] end3 = new byte[]{97, 97, 98};
        byte[] splitPoint3 = new byte[]{97, 97, 97, 112};
        this.testGetSplitKey(start3, end3, splitPoint3, true);
        byte[] start4 = new byte[]{97, 97, 97};
        byte[] end4 = new byte[]{97, 97, 97, 122};
        byte[] splitPoint4 = new byte[]{97, 97, 97, 77};
        this.testGetSplitKey(start4, end4, splitPoint4, true);
        byte[] start5 = new byte[]{97, 97, 97};
        byte[] end5 = new byte[]{97, 97, 98, 97};
        byte[] splitPoint5 = new byte[]{97, 97, 97, 112};
        this.testGetSplitKey(start5, end5, splitPoint5, true);
        byte[] start6 = new byte[]{};
        byte[] end6 = new byte[]{104, 104, 104, 113, 113, 113, 119, 119};
        byte[] splitPoint6 = new byte[]{104};
        this.testGetSplitKey(start6, end6, splitPoint6, true);
        byte[] start7 = new byte[]{102, 102, 102, 102, 97, 97, 97};
        byte[] end7 = new byte[]{};
        byte[] splitPointText7 = new byte[]{102, 126, 126, 126, 126, 126, 126};
        byte[] splitPointBinary7 = new byte[]{102, 127, 127, 127, 127, 127, 127};
        this.testGetSplitKey(start7, end7, splitPointText7, true);
        this.testGetSplitKey(start7, end7, splitPointBinary7, false);
        byte[] start8 = new byte[]{};
        byte[] end8 = new byte[]{};
        byte[] splitPointText8 = new byte[]{79};
        byte[] splitPointBinary8 = new byte[]{0};
        this.testGetSplitKey(start8, end8, splitPointText8, true);
        this.testGetSplitKey(start8, end8, splitPointBinary8, false);
        byte[] start9 = new byte[]{13, -19, 126, 127};
        byte[] end9 = new byte[]{13, -19, 127, 0};
        byte[] splitPoint9 = new byte[]{13, -19, 127, -64};
        this.testGetSplitKey(start9, end9, splitPoint9, false);
    }
}

