/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestShortCircuitConnection {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testShortCircuitConnection() throws IOException, InterruptedException {
        String tnAsString = "testShortCircuitConnection";
        TableName tn = TableName.valueOf((String)tnAsString);
        HTableDescriptor htd = UTIL.createTableDescriptor(tnAsString);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"cf"));
        htd.addFamily(hcd);
        UTIL.createTable(htd, (byte[][])null);
        HRegionServer regionServer = UTIL.getRSForFirstRegionInTable(tn);
        ClusterConnection connection = regionServer.getConnection();
        HTableInterface tableIf = connection.getTable(tn);
        Assert.assertTrue((boolean)(tableIf instanceof HTable));
        HTable table = (HTable)tableIf;
        Assert.assertTrue((table.getConnection() == connection ? 1 : 0) != 0);
        AdminProtos.AdminService.BlockingInterface admin = connection.getAdmin(regionServer.getServerName());
        ClientProtos.ClientService.BlockingInterface client = connection.getClient(regionServer.getServerName());
        Assert.assertTrue((boolean)(admin instanceof RSRpcServices));
        Assert.assertTrue((boolean)(client instanceof RSRpcServices));
        ServerName anotherSn = ServerName.valueOf((String)regionServer.getServerName().getHostAndPort(), (long)EnvironmentEdgeManager.currentTime());
        admin = connection.getAdmin(anotherSn);
        client = connection.getClient(anotherSn);
        Assert.assertFalse((boolean)(admin instanceof RSRpcServices));
        Assert.assertFalse((boolean)(client instanceof RSRpcServices));
        Assert.assertTrue((connection.getAdmin().getConnection() == connection ? 1 : 0) != 0);
    }
}

