/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorSerializeRowNoNulls {
    private static final Log LOG = LogFactory.getLog((String)VectorSerializeRowNoNulls.class.getName());
    private SerializeWrite serializeWrite;
    private Writer[] writers;

    public VectorSerializeRowNoNulls(SerializeWrite serializeWrite) {
        this();
        this.serializeWrite = serializeWrite;
    }

    private VectorSerializeRowNoNulls() {
    }

    private Writer createWriter(TypeInfo typeInfo, int columnIndex) throws HiveException {
        Writer writer;
        ObjectInspector.Category category = typeInfo.getCategory();
        block0 : switch (category) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        writer = new BooleanWriter(columnIndex);
                        break block0;
                    }
                    case BYTE: {
                        writer = new ByteWriter(columnIndex);
                        break block0;
                    }
                    case SHORT: {
                        writer = new ShortWriter(columnIndex);
                        break block0;
                    }
                    case INT: {
                        writer = new IntWriter(columnIndex);
                        break block0;
                    }
                    case LONG: {
                        writer = new LongWriter(columnIndex);
                        break block0;
                    }
                    case DATE: {
                        writer = new DateWriter(columnIndex);
                        break block0;
                    }
                    case TIMESTAMP: {
                        writer = new TimestampWriter(columnIndex);
                        break block0;
                    }
                    case FLOAT: {
                        writer = new FloatWriter(columnIndex);
                        break block0;
                    }
                    case DOUBLE: {
                        writer = new DoubleWriter(columnIndex);
                        break block0;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        writer = new StringWriter(columnIndex);
                        break block0;
                    }
                    case BINARY: {
                        writer = new BinaryWriter(columnIndex);
                        break block0;
                    }
                    case DECIMAL: {
                        writer = new HiveDecimalWriter(columnIndex);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        writer = new IntervalYearMonthWriter(columnIndex);
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        writer = new IntervalDayTimeWriter(columnIndex);
                        break block0;
                    }
                }
                throw new HiveException("Unexpected primitive type category " + primitiveCategory);
            }
            default: {
                throw new HiveException("Unexpected type category " + category);
            }
        }
        return writer;
    }

    public void init(List<String> typeNames, int[] columnMap) throws HiveException {
        this.writers = new Writer[typeNames.size()];
        for (int i = 0; i < typeNames.size(); ++i) {
            Writer writer;
            String typeName = typeNames.get(i);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            int columnIndex = columnMap[i];
            this.writers[i] = writer = this.createWriter(typeInfo, columnIndex);
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        this.writers = new Writer[typeNames.size()];
        for (int i = 0; i < typeNames.size(); ++i) {
            Writer writer;
            String typeName = typeNames.get(i);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            this.writers[i] = writer = this.createWriter(typeInfo, i);
        }
    }

    public void init(PrimitiveTypeInfo[] primitiveTypeInfos, List<Integer> columnMap) throws HiveException {
        this.writers = new Writer[primitiveTypeInfos.length];
        for (int i = 0; i < primitiveTypeInfos.length; ++i) {
            Writer writer;
            int columnIndex = columnMap.get(i);
            this.writers[i] = writer = this.createWriter((TypeInfo)primitiveTypeInfos[i], columnIndex);
        }
    }

    public int getCount() {
        return this.writers.length;
    }

    public void setOutput(ByteStream.Output output) {
        this.serializeWrite.set(output);
    }

    public void setOutputAppend(ByteStream.Output output) {
        this.serializeWrite.setAppend(output);
    }

    public void serializeWriteNoNulls(VectorizedRowBatch batch, int batchIndex) throws IOException {
        for (Writer writer : this.writers) {
            writer.apply(batch, batchIndex);
        }
    }

    private class HiveDecimalWriter
    extends Writer {
        HiveDecimalWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DecimalColumnVector colVector = (DecimalColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeHiveDecimal(colVector.vector[colVector.isRepeating ? 0 : batchIndex].getHiveDecimal());
        }
    }

    private class BinaryWriter
    extends Writer {
        BinaryWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                VectorSerializeRowNoNulls.this.serializeWrite.writeBinary(colVector.vector[0], colVector.start[0], colVector.length[0]);
            } else {
                VectorSerializeRowNoNulls.this.serializeWrite.writeBinary(colVector.vector[batchIndex], colVector.start[batchIndex], colVector.length[batchIndex]);
            }
        }
    }

    private class StringWriter
    extends Writer {
        StringWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                VectorSerializeRowNoNulls.this.serializeWrite.writeString(colVector.vector[0], colVector.start[0], colVector.length[0]);
            } else {
                VectorSerializeRowNoNulls.this.serializeWrite.writeString(colVector.vector[batchIndex], colVector.start[batchIndex], colVector.length[batchIndex]);
            }
        }
    }

    private class DoubleWriter
    extends AbstractDoubleWriter {
        DoubleWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DoubleColumnVector colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeDouble(colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class FloatWriter
    extends AbstractDoubleWriter {
        FloatWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DoubleColumnVector colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeFloat((float)colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private abstract class AbstractDoubleWriter
    extends Writer {
        AbstractDoubleWriter(int columnIndex) {
            super(columnIndex);
        }
    }

    private class IntervalDayTimeWriter
    extends AbstractLongWriter {
        IntervalDayTimeWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeHiveIntervalDayTime(colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class IntervalYearMonthWriter
    extends AbstractLongWriter {
        IntervalYearMonthWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeHiveIntervalYearMonth((int)colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class TimestampWriter
    extends AbstractLongWriter {
        Timestamp scratchTimestamp;

        TimestampWriter(int columnIndex) {
            super(columnIndex);
            this.scratchTimestamp = new Timestamp(0L);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            TimestampUtils.assignTimeInNanoSec(colVector.vector[colVector.isRepeating ? 0 : batchIndex], this.scratchTimestamp);
            VectorSerializeRowNoNulls.this.serializeWrite.writeTimestamp(this.scratchTimestamp);
        }
    }

    private class DateWriter
    extends AbstractLongWriter {
        DateWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeDate((int)colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class LongWriter
    extends AbstractLongWriter {
        LongWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeLong(colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class IntWriter
    extends AbstractLongWriter {
        IntWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeInt((int)colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class ShortWriter
    extends AbstractLongWriter {
        ShortWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeShort((short)colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class ByteWriter
    extends AbstractLongWriter {
        ByteWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeByte((byte)colVector.vector[colVector.isRepeating ? 0 : batchIndex]);
        }
    }

    private class BooleanWriter
    extends AbstractLongWriter {
        BooleanWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        void apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            VectorSerializeRowNoNulls.this.serializeWrite.writeBoolean(colVector.vector[colVector.isRepeating ? 0 : batchIndex] != 0L);
        }
    }

    private abstract class AbstractLongWriter
    extends Writer {
        AbstractLongWriter(int columnIndex) {
            super(columnIndex);
        }
    }

    private abstract class Writer {
        protected int columnIndex;

        Writer(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        abstract void apply(VectorizedRowBatch var1, int var2) throws IOException;
    }
}

