/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;

public abstract class MapJoinKey {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final HashSet<PrimitiveObjectInspector.PrimitiveCategory> SUPPORTED_PRIMITIVES = new HashSet();

    public abstract void write(MapJoinObjectSerDeContext var1, ObjectOutputStream var2) throws IOException, SerDeException;

    public abstract boolean hasAnyNulls(int var1, boolean[] var2);

    public static MapJoinKey read(ByteStream.Output output, MapJoinObjectSerDeContext context, Writable writable) throws SerDeException, HiveException {
        SerDe serde = context.getSerDe();
        Object obj = serde.deserialize(writable);
        MapJoinKeyObject result = new MapJoinKeyObject();
        result.read(serde.getObjectInspector(), obj);
        return result;
    }

    public static boolean isSupportedField(ObjectInspector foi) {
        if (foi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        PrimitiveObjectInspector.PrimitiveCategory pc = ((PrimitiveObjectInspector)foi).getPrimitiveCategory();
        return SUPPORTED_PRIMITIVES.contains(pc);
    }

    public static boolean isSupportedField(String typeName) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        PrimitiveObjectInspector.PrimitiveCategory pc = primitiveTypeInfo.getPrimitiveCategory();
        return SUPPORTED_PRIMITIVES.contains(pc);
    }

    public static MapJoinKey readFromVector(ByteStream.Output output, MapJoinKey key, Object[] keyObject, List<ObjectInspector> keyOIs, boolean mayReuseKey) throws HiveException {
        MapJoinKeyObject result = mayReuseKey ? (MapJoinKeyObject)key : new MapJoinKeyObject();
        result.setKeyObjects(keyObject);
        return result;
    }

    public static ByteStream.Output serializeVector(ByteStream.Output byteStream, VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch, boolean[] nulls, boolean[] sortableSortOrders) throws HiveException, SerDeException {
        Object[] fieldData = new Object[keyOutputWriters.length];
        ArrayList<ObjectInspector> fieldOis = new ArrayList<ObjectInspector>();
        for (int i = 0; i < keyOutputWriters.length; ++i) {
            VectorExpressionWriter writer = keyOutputWriters[i];
            fieldOis.add(writer.getObjectInspector());
            fieldData[i] = keyWrapperBatch.getWritableKeyValue(kw, i, writer);
            if (nulls == null) continue;
            nulls[i] = fieldData[i] == null;
        }
        return MapJoinKey.serializeRow(byteStream, fieldData, fieldOis, sortableSortOrders);
    }

    public static MapJoinKey readFromRow(ByteStream.Output output, MapJoinKey key, Object[] keyObject, List<ObjectInspector> keyFieldsOI, boolean mayReuseKey) throws HiveException {
        MapJoinKeyObject result = mayReuseKey ? (MapJoinKeyObject)key : new MapJoinKeyObject();
        result.readFromRow(keyObject, keyFieldsOI);
        return result;
    }

    public static ByteStream.Output serializeRow(ByteStream.Output byteStream, Object[] fieldData, List<ObjectInspector> fieldOis, boolean[] sortableSortOrders) throws HiveException {
        if (byteStream == null) {
            byteStream = new ByteStream.Output();
        } else {
            byteStream.reset();
        }
        try {
            if (fieldData.length == 0) {
                byteStream.reset();
            } else if (sortableSortOrders == null) {
                LazyBinarySerDe.serializeStruct((ByteStream.RandomAccessOutput)byteStream, (Object[])fieldData, fieldOis);
            } else {
                BinarySortableSerDe.serializeStruct((ByteStream.Output)byteStream, (Object[])fieldData, fieldOis, (boolean[])sortableSortOrders);
            }
        }
        catch (SerDeException e) {
            throw new HiveException("Serialization error", e);
        }
        return byteStream;
    }

    static {
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.VOID);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BYTE);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.SHORT);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.INT);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.LONG);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.DATE);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_YEAR_MONTH);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR);
        SUPPORTED_PRIMITIVES.add(PrimitiveObjectInspector.PrimitiveCategory.CHAR);
    }
}

