/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigCounters;
import org.apache.pig.PigWarning;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.FileList;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;

public class DistinctDataBag
extends DefaultAbstractBag {
    private static final long serialVersionUID = 2L;
    private static final Log log = LogFactory.getLog(DistinctDataBag.class);
    private static final InterSedes SEDES = InterSedesFactory.getInterSedesInstance();

    public DistinctDataBag() {
        this.mContents = new HashSet();
    }

    public DistinctDataBag(Set<Tuple> tuples) {
        this.mContents = tuples;
        this.mSize = this.mContents.size();
        this.markSpillableIfNecessary();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        if (this.mSpillFiles != null && this.mSpillFiles.size() > 0) {
            Iterator<Tuple> iter = this.iterator();
            int newSize = 0;
            while (iter.hasNext()) {
                ++newSize;
                iter.next();
            }
            Collection collection = this.mContents;
            synchronized (collection) {
                this.mSize = newSize;
            }
        }
        return this.mSize;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new DistinctDataBagIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Tuple t) {
        Collection collection = this.mContents;
        synchronized (collection) {
            if (this.mContents.add(t)) {
                ++this.mSize;
            }
        }
        this.markSpillableIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long spill() {
        long spilled;
        block21: {
            if (this.mContents.size() == 0) {
                return 0L;
            }
            spilled = 0L;
            Collection collection = this.mContents;
            synchronized (collection) {
                DataOutputStream out = null;
                try {
                    out = this.getSpillFile();
                }
                catch (IOException ioe) {
                    this.warn("Unable to create tmp file to spill to disk", PigWarning.UNABLE_TO_CREATE_FILE_TO_SPILL, ioe);
                    return 0L;
                }
                try {
                    if (this.mContents instanceof ArrayList) {
                        Iterator i = this.mContents.iterator();
                        while (i.hasNext()) {
                            SEDES.writeDatum(out, i.next(), (byte)110);
                            if ((++spilled & 0x3FFFL) != 0L) continue;
                            this.reportProgress();
                        }
                    } else {
                        Object[] array = new Tuple[this.mContents.size()];
                        this.mContents.toArray(array);
                        Arrays.sort(array);
                        for (int i = 0; i < array.length; ++i) {
                            array[i].write((DataOutput)out);
                            if ((++spilled & 0x3FFFL) != 0L) continue;
                            this.reportProgress();
                        }
                    }
                    out.flush();
                    out.close();
                    out = null;
                    this.mContents.clear();
                    if (out == null) break block21;
                }
                catch (Throwable e) {
                    try {
                        this.mSpillFiles.remove(this.mSpillFiles.size() - 1);
                        this.warn("Unable to spill contents to disk", PigWarning.UNABLE_TO_SPILL, e);
                        long l = 0L;
                        return l;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e2) {
                                this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e2);
                            }
                        }
                    }
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                }
            }
        }
        this.incSpillCount(PigCounters.SPILLABLE_MEMORY_MANAGER_SPILL_COUNT);
        return spilled;
    }

    private class DistinctDataBagIterator
    implements Iterator<Tuple> {
        private Tuple mBuf = null;
        private int mMemoryPtr = 0;
        private TreeSet<TContainer> mMergeTree = null;
        private ArrayList<DataInputStream> mStreams = null;
        private int mCntr = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DistinctDataBagIterator() {
            Collection collection = DistinctDataBag.this.mContents;
            synchronized (collection) {
                if (DistinctDataBag.this.mContents instanceof Set) {
                    this.preMerge();
                    ArrayList l = new ArrayList(DistinctDataBag.this.mContents);
                    Collections.sort(l);
                    DistinctDataBag.this.mContents = l;
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.mBuf = this.next();
            return this.mBuf != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tuple next() {
            if ((this.mCntr++ & 0x3FF) == 0) {
                DistinctDataBag.this.reportProgress();
            }
            if (this.mBuf != null) {
                Tuple t = this.mBuf;
                this.mBuf = null;
                return t;
            }
            boolean spilled = false;
            Collection collection = DistinctDataBag.this.mContents;
            synchronized (collection) {
                if (DistinctDataBag.this.mSpillFiles == null || DistinctDataBag.this.mSpillFiles.size() == 0) {
                    return this.readFromMemory();
                }
                if (this.mMemoryPtr > 0 && DistinctDataBag.this.mContents.size() == 0) {
                    spilled = true;
                }
            }
            if (spilled) {
                DataInputStream in;
                try {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)DistinctDataBag.this.mSpillFiles.get(DistinctDataBag.this.mSpillFiles.size() - 1))));
                    if (this.mStreams == null) {
                        this.mMergeTree = new TreeSet();
                        this.mStreams = new ArrayList(1);
                    }
                    this.mStreams.add(in);
                }
                catch (FileNotFoundException fnfe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)fnfe);
                    throw new RuntimeException(msg, fnfe);
                }
                for (int i = 0; i < this.mMemoryPtr; ++i) {
                    try {
                        SEDES.readDatum(in);
                        continue;
                    }
                    catch (EOFException eof) {
                        throw new RuntimeException("Ran out of tuples to read prematurely.", eof);
                    }
                    catch (IOException ioe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                }
                this.mMemoryPtr = 0;
                this.addToQueue(null, DistinctDataBag.this.mSpillFiles.size() - 1);
            }
            return this.readFromTree();
        }

        @Override
        public void remove() {
        }

        private Tuple readFromTree() {
            if (this.mMergeTree == null) {
                this.mMergeTree = new TreeSet();
                this.mStreams = new ArrayList(DistinctDataBag.this.mSpillFiles.size() + 1);
                Iterator i = DistinctDataBag.this.mSpillFiles.iterator();
                while (i.hasNext()) {
                    try {
                        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)i.next())));
                        this.mStreams.add(in);
                        this.addToQueue(null, this.mStreams.size() - 1);
                    }
                    catch (FileNotFoundException fnfe) {
                        String msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)fnfe);
                        throw new RuntimeException(msg, fnfe);
                    }
                }
                if (DistinctDataBag.this.mContents.size() > 0) {
                    this.addToQueue(null, -1);
                }
            }
            if (this.mMergeTree.size() == 0) {
                return null;
            }
            TContainer c = this.mMergeTree.first();
            this.mMergeTree.remove(c);
            Tuple t = c.tuple;
            this.addToQueue(c, c.fileNum);
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToQueue(TContainer c, int fileNum) {
            if (c == null) {
                c = new TContainer();
            }
            c.fileNum = fileNum;
            if (fileNum == -1) {
                Collection collection = DistinctDataBag.this.mContents;
                synchronized (collection) {
                    do {
                        c.tuple = this.readFromMemory();
                        if (c.tuple == null || !this.mMergeTree.add(c)) continue;
                        return;
                    } while (c.tuple != null);
                }
                return;
            }
            DataInputStream in = this.mStreams.get(fileNum);
            if (in != null) {
                try {
                    do {
                        c.tuple = (Tuple)SEDES.readDatum(in);
                    } while (!this.mMergeTree.add(c));
                    return;
                }
                catch (EOFException eof) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Failed to close spill file.", (Throwable)e);
                    }
                    this.mStreams.set(fileNum, null);
                    return;
                }
                catch (IOException ioe) {
                    String msg = "Unable to find our spill file.";
                    log.fatal((Object)msg, (Throwable)ioe);
                    throw new RuntimeException(msg, ioe);
                }
            }
        }

        private Tuple readFromMemory() {
            if (DistinctDataBag.this.mContents.size() == 0) {
                return null;
            }
            if (this.mMemoryPtr < DistinctDataBag.this.mContents.size()) {
                return (Tuple)((ArrayList)DistinctDataBag.this.mContents).get(this.mMemoryPtr++);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preMerge() {
            if (DistinctDataBag.this.mSpillFiles == null || DistinctDataBag.this.mSpillFiles.size() <= 100) {
                return;
            }
            try {
                LinkedList<File> ll = new LinkedList<File>(DistinctDataBag.this.mSpillFiles);
                LinkedList<File> filesToDelete = new LinkedList<File>();
                while (ll.size() > 100) {
                    String msg;
                    ListIterator i = ll.listIterator();
                    this.mStreams = new ArrayList(100);
                    this.mMergeTree = new TreeSet();
                    for (int j = 0; j < 100; ++j) {
                        try {
                            File f = (File)i.next();
                            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                            this.mStreams.add(in);
                            this.addToQueue(null, this.mStreams.size() - 1);
                            i.remove();
                            filesToDelete.add(f);
                            continue;
                        }
                        catch (FileNotFoundException fnfe) {
                            msg = "Unable to find our spill file.";
                            log.fatal((Object)msg, (Throwable)fnfe);
                            throw new RuntimeException(msg, fnfe);
                        }
                    }
                    DataOutputStream out = null;
                    try {
                        Tuple t;
                        out = DistinctDataBag.this.getSpillFile();
                        ll.add((File)DistinctDataBag.this.mSpillFiles.get(DistinctDataBag.this.mSpillFiles.size() - 1));
                        while ((t = this.readFromTree()) != null) {
                            t.write(out);
                        }
                        out.flush();
                    }
                    catch (IOException ioe) {
                        msg = "Unable to find our spill file.";
                        log.fatal((Object)msg, (Throwable)ioe);
                        throw new RuntimeException(msg, ioe);
                    }
                    finally {
                        if (out == null) continue;
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            DistinctDataBag.this.warn("Error closing spill", PigWarning.UNABLE_TO_CLOSE_SPILL_FILE, e);
                        }
                    }
                }
                for (File f : filesToDelete) {
                    if (f.delete()) continue;
                    log.warn((Object)("Failed to delete spill file: " + f.getPath()));
                }
                DistinctDataBag.this.mSpillFiles.clear();
                DistinctDataBag.this.mSpillFiles = new FileList(ll);
            }
            finally {
                this.mStreams = null;
                this.mMergeTree = null;
            }
        }

        private class TContainer
        implements Comparable<TContainer> {
            public Tuple tuple;
            public int fileNum;

            private TContainer() {
            }

            @Override
            public int compareTo(TContainer other) {
                return this.tuple.compareTo(other.tuple);
            }

            public boolean equals(Object obj) {
                if (obj instanceof TContainer) {
                    return this.tuple.equals(((TContainer)obj).tuple);
                }
                return false;
            }

            public int hashCode() {
                return this.tuple.hashCode();
            }
        }
    }
}

