/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSnapshotFromAdmin {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFromAdmin.class);

    @Test(timeout=60000L)
    public void testBackoffLogic() throws Exception {
        int pauseTime = 100;
        int maxWaitTime = HConstants.RETRY_BACKOFF[HConstants.RETRY_BACKOFF.length - 1] * 100;
        int numRetries = HConstants.RETRY_BACKOFF.length;
        long ignoreExpectedTime = 0L;
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            ignoreExpectedTime += (long)(HConstants.RETRY_BACKOFF[i] * 100);
        }
        long time = 300 + maxWaitTime / numRetries * 3 + 300;
        Assert.assertTrue((String)"Capped snapshot wait time isn't less that the uncapped backoff time - further testing won't prove anything.", (time < ignoreExpectedTime ? 1 : 0) != 0);
        ConnectionManager.HConnectionImplementation mockConnection = (ConnectionManager.HConnectionImplementation)Mockito.mock(ConnectionManager.HConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.client.retries.number", numRetries);
        conf.setLong("hbase.client.pause", 100L);
        MasterKeepAliveConnection mockMaster = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class);
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockConnection.getKeepAliveMasterService()).thenReturn((Object)mockMaster);
        RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(conf);
        RpcControllerFactory controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        Mockito.when((Object)controllerFactory.newController()).thenReturn(Mockito.mock(PayloadCarryingRpcController.class));
        Mockito.when((Object)mockConnection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
        Mockito.when((Object)mockConnection.getRpcControllerFactory()).thenReturn((Object)controllerFactory);
        MasterProtos.SnapshotResponse response = MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout((long)maxWaitTime).build();
        Mockito.when((Object)mockMaster.snapshot((RpcController)Mockito.any(), (MasterProtos.SnapshotRequest)Mockito.any(MasterProtos.SnapshotRequest.class))).thenReturn((Object)response);
        MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
        builder.setDone(false);
        Mockito.when((Object)mockMaster.isSnapshotDone((RpcController)Mockito.any(), (MasterProtos.IsSnapshotDoneRequest)Mockito.any(MasterProtos.IsSnapshotDoneRequest.class))).thenReturn((Object)builder.build(), (Object[])new MasterProtos.IsSnapshotDoneResponse[]{builder.build(), builder.build(), builder.build(), builder.build(), builder.setDone(true).build()});
        HBaseAdmin admin = new HBaseAdmin((ClusterConnection)mockConnection);
        String snapshot = "snapshot";
        TableName table = TableName.valueOf((String)"table");
        long start = System.currentTimeMillis();
        admin.snapshot(snapshot, table);
        long finish = System.currentTimeMillis();
        long elapsed = finish - start;
        Assert.assertTrue((String)("Elapsed time:" + elapsed + " is more than expected max:" + time), (elapsed <= time ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testValidateSnapshotName() throws Exception {
        ConnectionManager.HConnectionImplementation mockConnection = (ConnectionManager.HConnectionImplementation)Mockito.mock(ConnectionManager.HConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        RpcRetryingCallerFactory callerFactory = new RpcRetryingCallerFactory(conf);
        RpcControllerFactory controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        Mockito.when((Object)controllerFactory.newController()).thenReturn(Mockito.mock(PayloadCarryingRpcController.class));
        Mockito.when((Object)mockConnection.getRpcRetryingCallerFactory()).thenReturn((Object)callerFactory);
        Mockito.when((Object)mockConnection.getRpcControllerFactory()).thenReturn((Object)controllerFactory);
        HBaseAdmin admin = new HBaseAdmin((ClusterConnection)mockConnection);
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        this.failSnapshotStart((Admin)admin, builder.setName(".hbase-snapshot").build());
        this.failSnapshotStart((Admin)admin, builder.setName("-snapshot").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snapshot fails").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snap$hot").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snap:hot").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snapshot").setTable(".table").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snapshot").setTable("-table").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snapshot").setTable("table fails").build());
        this.failSnapshotStart((Admin)admin, builder.setName("snapshot").setTable("tab%le").build());
        MasterKeepAliveConnection master = (MasterKeepAliveConnection)Mockito.mock(MasterKeepAliveConnection.class);
        Mockito.when((Object)mockConnection.getKeepAliveMasterService()).thenReturn((Object)master);
        MasterProtos.SnapshotResponse response = MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(0L).build();
        Mockito.when((Object)master.snapshot((RpcController)Mockito.any(), (MasterProtos.SnapshotRequest)Mockito.any(MasterProtos.SnapshotRequest.class))).thenReturn((Object)response);
        MasterProtos.IsSnapshotDoneResponse doneResponse = MasterProtos.IsSnapshotDoneResponse.newBuilder().setDone(true).build();
        Mockito.when((Object)master.isSnapshotDone((RpcController)Mockito.any(), (MasterProtos.IsSnapshotDoneRequest)Mockito.any(MasterProtos.IsSnapshotDoneRequest.class))).thenReturn((Object)doneResponse);
        admin.snapshot(builder.setName("snapshot").setTable("table").build());
    }

    private void failSnapshotStart(Admin admin, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        try {
            admin.snapshot(snapshot);
            Assert.fail((String)("Snapshot should not have succeed with name:" + snapshot.getName()));
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)("Correctly failed to start snapshot:" + e.getMessage()));
        }
    }
}

