/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.VisibilityConstraint;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Text;

public class CreateTableCommand
extends Shell.Command {
    private Option createTableOptCopySplits;
    private Option createTableOptCopyConfig;
    private Option createTableOptSplit;
    private Option createTableOptTimeLogical;
    private Option createTableOptTimeMillis;
    private Option createTableNoDefaultIters;
    private Option createTableOptEVC;
    private Option base64Opt;
    private Option createTableOptFormatter;
    public static String testTable;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException, ClassNotFoundException {
        String oldTable;
        String testTableName = cl.getArgs()[0];
        if (!testTableName.matches("^\\w+$")) {
            shellState.getReader().printString("Only letters, numbers and underscores are allowed for use in table names. \n");
            throw new IllegalArgumentException();
        }
        String tableName = cl.getArgs()[0];
        if (shellState.getConnector().tableOperations().exists(tableName)) {
            throw new TableExistsException(null, tableName, null);
        }
        TreeSet<Text> partitions = new TreeSet<Text>();
        boolean decode = cl.hasOption(this.base64Opt.getOpt());
        if (cl.hasOption(this.createTableOptSplit.getOpt())) {
            String f = cl.getOptionValue(this.createTableOptSplit.getOpt());
            Scanner file = new Scanner(new File(f));
            while (file.hasNextLine()) {
                String line = file.nextLine();
                if (line.isEmpty()) continue;
                partitions.add(decode ? new Text(Base64.decodeBase64((byte[])line.getBytes())) : new Text(line));
            }
        } else if (cl.hasOption(this.createTableOptCopySplits.getOpt())) {
            oldTable = cl.getOptionValue(this.createTableOptCopySplits.getOpt());
            if (!shellState.getConnector().tableOperations().exists(oldTable)) {
                throw new TableNotFoundException(null, oldTable, null);
            }
            partitions.addAll(shellState.getConnector().tableOperations().listSplits(oldTable));
        }
        if (cl.hasOption(this.createTableOptCopyConfig.getOpt())) {
            oldTable = cl.getOptionValue(this.createTableOptCopyConfig.getOpt());
            if (!shellState.getConnector().tableOperations().exists(oldTable)) {
                throw new TableNotFoundException(null, oldTable, null);
            }
        }
        TimeType timeType = TimeType.MILLIS;
        if (cl.hasOption(this.createTableOptTimeLogical.getOpt())) {
            timeType = TimeType.LOGICAL;
        }
        shellState.getConnector().tableOperations().create(tableName, true, timeType);
        if (partitions.size() > 0) {
            shellState.getConnector().tableOperations().addSplits(tableName, partitions);
        }
        shellState.setTableName(tableName);
        if (cl.hasOption(this.createTableNoDefaultIters.getOpt())) {
            for (String key : IteratorUtil.generateInitialTableProperties(true).keySet()) {
                shellState.getConnector().tableOperations().removeProperty(tableName, key);
            }
        }
        if (cl.hasOption(this.createTableOptCopyConfig.getOpt()) && shellState.getConnector().tableOperations().exists(tableName)) {
            Iterable<Map.Entry<String, String>> configuration = shellState.getConnector().tableOperations().getProperties(cl.getOptionValue(this.createTableOptCopyConfig.getOpt()));
            for (Map.Entry<String, String> entry : configuration) {
                if (!Property.isValidTablePropertyKey(entry.getKey())) continue;
                shellState.getConnector().tableOperations().setProperty(tableName, entry.getKey(), entry.getValue());
            }
        }
        if (cl.hasOption(this.createTableOptEVC.getOpt())) {
            try {
                shellState.getConnector().tableOperations().addConstraint(tableName, VisibilityConstraint.class.getName());
            }
            catch (AccumuloException e) {
                Shell.log.warn((Object)(e.getMessage() + " while setting visibility constraint, but table was created"));
            }
        }
        if (cl.hasOption(this.createTableOptFormatter.getOpt())) {
            String formatterClass = cl.getOptionValue(this.createTableOptFormatter.getOpt());
            shellState.getConnector().tableOperations().setProperty(tableName, Property.TABLE_FORMATTER_CLASS.toString(), formatterClass);
        }
        return 0;
    }

    @Override
    public String description() {
        return "creates a new table, with optional aggregators and optionally pre-split";
    }

    @Override
    public String usage() {
        return this.getName() + " <tableName>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.createTableOptCopyConfig = new Option("cc", "copy-config", true, "table to copy configuration from");
        this.createTableOptCopySplits = new Option("cs", "copy-splits", true, "table to copy current splits from");
        this.createTableOptSplit = new Option("sf", "splits-file", true, "file with a newline-separated list of rows to split the table with");
        this.createTableOptTimeLogical = new Option("tl", "time-logical", false, "use logical time");
        this.createTableOptTimeMillis = new Option("tm", "time-millis", false, "use time in milliseconds");
        this.createTableNoDefaultIters = new Option("ndi", "no-default-iterators", false, "prevent creation of the normal default iterator set");
        this.createTableOptEVC = new Option("evc", "enable-visibility-constraint", false, "prevent users from writing data they cannot read.  When enabling this, consider disabling bulk import and alter table.");
        this.createTableOptFormatter = new Option("f", "formatter", true, "default formatter to set");
        this.createTableOptCopyConfig.setArgName("table");
        this.createTableOptCopySplits.setArgName("table");
        this.createTableOptSplit.setArgName("filename");
        this.createTableOptFormatter.setArgName("className");
        OptionGroup splitOrCopySplit = new OptionGroup();
        splitOrCopySplit.addOption(this.createTableOptSplit);
        splitOrCopySplit.addOption(this.createTableOptCopySplits);
        OptionGroup timeGroup = new OptionGroup();
        timeGroup.addOption(this.createTableOptTimeLogical);
        timeGroup.addOption(this.createTableOptTimeMillis);
        this.base64Opt = new Option("b64", "base64encoded", false, "decode encoded split points");
        o.addOption(this.base64Opt);
        o.addOptionGroup(splitOrCopySplit);
        o.addOptionGroup(timeGroup);
        o.addOption(this.createTableOptSplit);
        o.addOption(this.createTableOptCopyConfig);
        o.addOption(this.createTableNoDefaultIters);
        o.addOption(this.createTableOptEVC);
        o.addOption(this.createTableOptFormatter);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

