/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class OpTimer {
    private Logger log;
    private Level level;
    private long t1;
    private long opid;
    private static AtomicLong nextOpid = new AtomicLong();

    public OpTimer(Logger log, Level level) {
        this.log = log;
        this.level = level;
    }

    public OpTimer start(String msg) {
        this.opid = nextOpid.getAndIncrement();
        if (this.log.isEnabledFor((Priority)this.level)) {
            this.log.log((Priority)this.level, (Object)("tid=" + Thread.currentThread().getId() + " oid=" + this.opid + "  " + msg));
        }
        this.t1 = System.currentTimeMillis();
        return this;
    }

    public void stop(String msg) {
        if (this.log.isEnabledFor((Priority)this.level)) {
            long t2 = System.currentTimeMillis();
            String duration = String.format("%.3f secs", (double)(t2 - this.t1) / 1000.0);
            msg = msg.replace("%DURATION%", duration);
            this.log.log((Priority)this.level, (Object)("tid=" + Thread.currentThread().getId() + " oid=" + this.opid + "  " + msg));
        }
    }
}

