/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.ABlockReader;
import org.apache.accumulo.core.file.rfile.MultiLevelIndex;
import org.apache.accumulo.core.file.rfile.RelativeKey;

public class BlockIndex {
    private AtomicInteger accessCount = new AtomicInteger(0);
    private volatile BlockIndexEntry[] blockIndex = null;

    public static BlockIndex getIndex(ABlockReader cacheBlock, MultiLevelIndex.IndexEntry indexEntry) throws IOException {
        BlockIndex blockIndex = cacheBlock.getIndex(BlockIndex.class);
        int accessCount = blockIndex.accessCount.incrementAndGet();
        if (accessCount >= 2 && BlockIndex.isPowerOfTwo(accessCount)) {
            blockIndex.buildIndex(accessCount, cacheBlock, indexEntry);
        }
        if (blockIndex.blockIndex != null) {
            return blockIndex;
        }
        return null;
    }

    private static boolean isPowerOfTwo(int x) {
        return x > 0 && (x & x - 1) == 0;
    }

    public BlockIndexEntry seekBlock(Key startKey, ABlockReader cacheBlock) {
        int index;
        Object[] blockIndex = this.blockIndex;
        int pos = Arrays.binarySearch(blockIndex, new BlockIndexEntry(startKey));
        if (pos < 0) {
            if (pos == -1) {
                return null;
            }
            index = pos * -1 - 2;
        } else {
            for (index = pos; index > 0 && ((BlockIndexEntry)blockIndex[index]).getPrevKey().equals(startKey); --index) {
            }
        }
        while (index - 1 > 0 && ((BlockIndexEntry)blockIndex[index]).getPrevKey().equals(((BlockIndexEntry)blockIndex[index - 1]).getPrevKey())) {
            --index;
        }
        if (index == 0 && ((BlockIndexEntry)blockIndex[index]).getPrevKey().equals(startKey)) {
            return null;
        }
        Object bie = blockIndex[index];
        cacheBlock.seek(((BlockIndexEntry)bie).pos);
        return bie;
    }

    private synchronized void buildIndex(int indexEntries, ABlockReader cacheBlock, MultiLevelIndex.IndexEntry indexEntry) throws IOException {
        cacheBlock.seek(0);
        RelativeKey rk = new RelativeKey();
        Value val = new Value();
        int interval = indexEntry.getNumEntries() / indexEntries;
        if (interval <= 32) {
            return;
        }
        if (this.blockIndex != null && this.blockIndex.length > indexEntries - 1) {
            return;
        }
        ArrayList<BlockIndexEntry> index = new ArrayList<BlockIndexEntry>(indexEntries - 1);
        for (int count = 0; count < indexEntry.getNumEntries() - interval + 1; ++count) {
            Key myPrevKey = rk.getKey();
            int pos = cacheBlock.getPosition();
            rk.readFields(cacheBlock);
            val.readFields(cacheBlock);
            if (count <= 0 || count % interval != 0) continue;
            index.add(new BlockIndexEntry(pos, indexEntry.getNumEntries() - count, myPrevKey));
        }
        this.blockIndex = index.toArray(new BlockIndexEntry[index.size()]);
        cacheBlock.seek(0);
    }

    BlockIndexEntry[] getIndexEntries() {
        return this.blockIndex;
    }

    public static class BlockIndexEntry
    implements Comparable<BlockIndexEntry> {
        private Key prevKey;
        private int entriesLeft;
        private int pos;

        public BlockIndexEntry(int pos, int entriesLeft, Key prevKey) {
            this.pos = pos;
            this.entriesLeft = entriesLeft;
            this.prevKey = prevKey;
        }

        public BlockIndexEntry(Key key) {
            this.prevKey = key;
        }

        public int getEntriesLeft() {
            return this.entriesLeft;
        }

        @Override
        public int compareTo(BlockIndexEntry o) {
            return this.prevKey.compareTo(o.prevKey);
        }

        public String toString() {
            return this.prevKey + " " + this.entriesLeft + " " + this.pos;
        }

        public Key getPrevKey() {
            return this.prevKey;
        }
    }
}

