/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.apache.hadoop.io.Writable;

public interface AuthenticationToken
extends Writable,
Destroyable,
Cloneable {
    public void init(Properties var1);

    public Set<TokenProperty> getProperties();

    public AuthenticationToken clone();

    public static class TokenProperty
    implements Comparable<TokenProperty> {
        private String key;
        private String description;
        private boolean masked;

        public TokenProperty(String name, String description, boolean mask) {
            this.key = name;
            this.description = description;
            this.masked = mask;
        }

        public String toString() {
            return this.key + " - " + this.description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getMask() {
            return this.masked;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TokenProperty) {
                return ((TokenProperty)o).key.equals(this.key);
            }
            return false;
        }

        @Override
        public int compareTo(TokenProperty o) {
            return this.key.compareTo(o.key);
        }
    }

    public static class Properties
    implements Destroyable,
    Map<String, char[]> {
        private boolean destroyed = false;
        private HashMap<String, char[]> map = new HashMap();

        private void checkDestroyed() {
            if (this.destroyed) {
                throw new IllegalStateException();
            }
        }

        @Override
        public char[] put(String key, CharSequence value) {
            this.checkDestroyed();
            char[] toPut = new char[value.length()];
            for (int i = 0; i < value.length(); ++i) {
                toPut[i] = value.charAt(i);
            }
            return this.map.put(key, toPut);
        }

        public void putAllStrings(Map<String, ? extends CharSequence> map) {
            this.checkDestroyed();
            for (Map.Entry<String, ? extends CharSequence> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void destroy() throws DestroyFailedException {
            for (String key : this.keySet()) {
                char[] val = this.get(key);
                Arrays.fill(val, '\u0000');
            }
            this.clear();
            this.destroyed = true;
        }

        @Override
        public boolean isDestroyed() {
            return this.destroyed;
        }

        @Override
        public int size() {
            this.checkDestroyed();
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            this.checkDestroyed();
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            this.checkDestroyed();
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            this.checkDestroyed();
            return this.map.containsValue(value);
        }

        @Override
        public char[] get(Object key) {
            this.checkDestroyed();
            return this.map.get(key);
        }

        @Override
        public char[] put(String key, char[] value) {
            this.checkDestroyed();
            return this.map.put(key, value);
        }

        @Override
        public char[] remove(Object key) {
            this.checkDestroyed();
            return this.map.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends char[]> m) {
            this.checkDestroyed();
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.checkDestroyed();
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            this.checkDestroyed();
            return this.map.keySet();
        }

        @Override
        public Collection<char[]> values() {
            this.checkDestroyed();
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, char[]>> entrySet() {
            this.checkDestroyed();
            return this.map.entrySet();
        }
    }
}

