/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.mock.MockConfiguration;
import org.apache.accumulo.core.client.mock.MockTable;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.VisibilityFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.lang.NotImplementedException;

public class MockScannerBase
extends ScannerOptions
implements ScannerBase {
    protected final MockTable table;
    protected final Authorizations auths;

    MockScannerBase(MockTable mockTable, Authorizations authorizations) {
        this.table = mockTable;
        this.auths = authorizations;
    }

    static HashSet<ByteSequence> createColumnBSS(Collection<Column> columns) {
        HashSet<ByteSequence> columnSet = new HashSet<ByteSequence>();
        for (Column c : columns) {
            columnSet.add(new ArrayByteSequence(c.getColumnFamily()));
        }
        return columnSet;
    }

    public SortedKeyValueIterator<Key, Value> createFilter(SortedKeyValueIterator<Key, Value> inner) throws IOException {
        byte[] defaultLabels = new byte[]{};
        inner = new ColumnFamilySkippingIterator(new DeletingIterator(inner, false));
        ColumnQualifierFilter cqf = new ColumnQualifierFilter(inner, new HashSet<Column>(this.fetchedColumns));
        VisibilityFilter vf = new VisibilityFilter(cqf, this.auths, defaultLabels);
        MockConfiguration conf = new MockConfiguration(this.table.settings);
        MockIteratorEnvironment iterEnv = new MockIteratorEnvironment();
        SortedKeyValueIterator<Key, Value> result = iterEnv.getTopLevelIterator(IteratorUtil.loadIterators(IteratorUtil.IteratorScope.scan, vf, null, conf, this.serverSideIteratorList, this.serverSideIteratorOptions, iterEnv, false));
        return result;
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        throw new UnsupportedOperationException();
    }

    static class MockIteratorEnvironment
    implements IteratorEnvironment {
        private ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators = new ArrayList();

        MockIteratorEnvironment() {
        }

        @Override
        public SortedKeyValueIterator<Key, Value> reserveMapFileReader(String mapFileName) throws IOException {
            throw new NotImplementedException();
        }

        @Override
        public AccumuloConfiguration getConfig() {
            return AccumuloConfiguration.getDefaultConfiguration();
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
            this.topLevelIterators.add(iter);
        }

        SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
            if (this.topLevelIterators.isEmpty()) {
                return iter;
            }
            ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
            allIters.add(iter);
            return new MultiIterator(allIters, false);
        }
    }
}

