/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.FileUtil;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.AuthInfo;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ZooKeeperInstance
implements Instance {
    private static final Logger log = Logger.getLogger(ZooKeeperInstance.class);
    private String instanceId = null;
    private String instanceName = null;
    private final ZooCache zooCache;
    private final String zooKeepers;
    private final int zooKeepersSessionTimeOut;
    private AccumuloConfiguration conf = null;

    public ZooKeeperInstance(String instanceName, String zooKeepers) {
        this(instanceName, zooKeepers, (int)AccumuloConfiguration.getDefaultConfiguration().getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT));
    }

    public ZooKeeperInstance(String instanceName, String zooKeepers, int sessionTimeout) {
        ArgumentChecker.notNull(instanceName, zooKeepers);
        this.instanceName = instanceName;
        this.zooKeepers = zooKeepers;
        this.zooKeepersSessionTimeOut = sessionTimeout;
        this.zooCache = ZooCache.getInstance((String)zooKeepers, (int)sessionTimeout);
        this.getInstanceID();
    }

    public ZooKeeperInstance(UUID instanceId, String zooKeepers) {
        this(instanceId, zooKeepers, (int)AccumuloConfiguration.getDefaultConfiguration().getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT));
    }

    public ZooKeeperInstance(UUID instanceId, String zooKeepers, int sessionTimeout) {
        ArgumentChecker.notNull(instanceId, zooKeepers);
        this.instanceId = instanceId.toString();
        this.zooKeepers = zooKeepers;
        this.zooKeepersSessionTimeOut = sessionTimeout;
        this.zooCache = ZooCache.getInstance((String)zooKeepers, (int)sessionTimeout);
    }

    @Override
    public String getInstanceID() {
        if (this.instanceId == null) {
            String instanceNamePath = "/accumulo/instances/" + this.instanceName;
            byte[] iidb = this.zooCache.get(instanceNamePath);
            if (iidb == null) {
                throw new RuntimeException("Instance name " + this.instanceName + " does not exist in zookeeper.  Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
            }
            this.instanceId = new String(iidb);
        }
        if (this.zooCache.get("/accumulo/" + this.instanceId) == null) {
            if (this.instanceName == null) {
                throw new RuntimeException("Instance id " + this.instanceId + " does not exist in zookeeper");
            }
            throw new RuntimeException("Instance id " + this.instanceId + " pointed to by the name " + this.instanceName + " does not exist in zookeeper");
        }
        return this.instanceId;
    }

    @Override
    public List<String> getMasterLocations() {
        String masterLocPath = ZooUtil.getRoot(this) + "/masters/lock";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up master location in zoocache.");
        byte[] loc = ZooUtil.getLockData((ZooCache)this.zooCache, (String)masterLocPath);
        opTimer.stop("Found master at " + (loc == null ? null : new String(loc)) + " in %DURATION%");
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc));
    }

    @Override
    public String getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot(this) + "/root_tablet/location";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up root tablet location in zookeeper.");
        byte[] loc = this.zooCache.get(zRootLocPath);
        opTimer.stop("Found root tablet at " + (loc == null ? null : new String(loc)) + " in %DURATION%");
        if (loc == null) {
            return null;
        }
        return new String(loc).split("\\|")[0];
    }

    @Override
    public String getInstanceName() {
        if (this.instanceName == null) {
            this.instanceName = ZooKeeperInstance.lookupInstanceName(this.zooCache, UUID.fromString(this.getInstanceID()));
        }
        return this.instanceName;
    }

    @Override
    public String getZooKeepers() {
        return this.zooKeepers;
    }

    @Override
    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, TextUtil.getBytes(new Text(((Object)pass).toString())));
    }

    @Override
    @Deprecated
    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, ByteBufferUtil.toBytes(pass));
    }

    @Override
    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(CredentialHelper.create(principal, token, this.getInstanceID()));
    }

    private Connector getConnector(TCredentials credential) throws AccumuloException, AccumuloSecurityException {
        return new ConnectorImpl(this, credential);
    }

    @Override
    @Deprecated
    public Connector getConnector(String principal, byte[] pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(principal, new PasswordToken(pass));
    }

    @Override
    public AccumuloConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = AccumuloConfiguration.getDefaultConfiguration();
        }
        return this.conf;
    }

    @Override
    public void setConfiguration(AccumuloConfiguration conf) {
        this.conf = conf;
    }

    @Deprecated
    public static String lookupInstanceName(org.apache.accumulo.core.zookeeper.ZooCache zooCache, UUID instanceId) {
        return ZooKeeperInstance.lookupInstanceName((ZooCache)zooCache, instanceId);
    }

    public static String lookupInstanceName(ZooCache zooCache, UUID instanceId) {
        ArgumentChecker.notNull(zooCache, instanceId);
        for (String name : zooCache.getChildren("/accumulo/instances")) {
            String instanceNamePath = "/accumulo/instances/" + name;
            UUID iid = UUID.fromString(new String(zooCache.get(instanceNamePath)));
            if (!iid.equals(instanceId)) continue;
            return name;
        }
        return null;
    }

    @Deprecated
    public static String getInstanceIDFromHdfs(Path instanceDirectory) {
        try {
            FileSystem fs = FileUtil.getFileSystem(CachedConfiguration.getInstance(), AccumuloConfiguration.getSiteConfiguration());
            FileStatus[] files = null;
            try {
                files = fs.listStatus(instanceDirectory);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            log.debug((Object)("Trying to read instance id from " + instanceDirectory));
            if (files == null || files.length == 0) {
                log.error((Object)("unable obtain instance id at " + instanceDirectory));
                throw new RuntimeException("Accumulo not initialized, there is no instance id at " + instanceDirectory);
            }
            if (files.length != 1) {
                log.error((Object)("multiple potential instances in " + instanceDirectory));
                throw new RuntimeException("Accumulo found multiple possible instance ids in " + instanceDirectory);
            }
            String result = files[0].getPath().getName();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Accumulo not initialized, there is no instance id at " + instanceDirectory, e);
        }
    }

    @Override
    @Deprecated
    public Connector getConnector(AuthInfo auth) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(auth.user, auth.password);
    }
}

