/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.NativeCrc32;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestNativeCrc32 {
    private static final long BASE_POSITION = 0L;
    private static final int IO_BYTES_PER_CHECKSUM_DEFAULT = 512;
    private static final String IO_BYTES_PER_CHECKSUM_KEY = "io.bytes.per.checksum";
    private static final int NUM_CHUNKS = 3;
    private final DataChecksum.Type checksumType;
    private int bytesPerChecksum;
    private String fileName;
    private ByteBuffer data;
    private ByteBuffer checksums;
    private DataChecksum checksum;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(2);
        params.add(new Object[]{DataChecksum.Type.CRC32});
        params.add(new Object[]{DataChecksum.Type.CRC32C});
        return params;
    }

    public TestNativeCrc32(DataChecksum.Type checksumType) {
        this.checksumType = checksumType;
    }

    @Before
    public void setup() {
        Assume.assumeTrue((boolean)NativeCrc32.isAvailable());
        Assert.assertEquals((String)"These tests assume they can write a checksum value as a 4-byte int.", (long)4L, (long)this.checksumType.size);
        Configuration conf = new Configuration();
        this.bytesPerChecksum = conf.getInt(IO_BYTES_PER_CHECKSUM_KEY, 512);
        this.fileName = this.getClass().getSimpleName();
        this.checksum = DataChecksum.newDataChecksum((DataChecksum.Type)this.checksumType, (int)this.bytesPerChecksum);
    }

    @Test
    public void testVerifyChunkedSumsSuccess() throws ChecksumException {
        this.allocateDirectByteBuffers();
        this.fillDataAndValidChecksums();
        NativeCrc32.verifyChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (ByteBuffer)this.data, (String)this.fileName, (long)0L);
    }

    @Test
    public void testVerifyChunkedSumsFail() throws ChecksumException {
        this.allocateDirectByteBuffers();
        this.fillDataAndInvalidChecksums();
        this.exception.expect(ChecksumException.class);
        NativeCrc32.verifyChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (ByteBuffer)this.data, (String)this.fileName, (long)0L);
    }

    @Test
    public void testVerifyChunkedSumsSuccessOddSize() throws ChecksumException {
        --this.bytesPerChecksum;
        this.allocateDirectByteBuffers();
        this.fillDataAndValidChecksums();
        NativeCrc32.verifyChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (ByteBuffer)this.data, (String)this.fileName, (long)0L);
        ++this.bytesPerChecksum;
    }

    @Test
    public void testVerifyChunkedSumsByteArraySuccess() throws ChecksumException {
        this.allocateArrayByteBuffers();
        this.fillDataAndValidChecksums();
        NativeCrc32.verifyChunkedSumsByteArray((int)this.bytesPerChecksum, (int)this.checksumType.id, (byte[])this.checksums.array(), (int)this.checksums.position(), (byte[])this.data.array(), (int)this.data.position(), (int)this.data.remaining(), (String)this.fileName, (long)0L);
    }

    @Test
    public void testVerifyChunkedSumsByteArrayFail() throws ChecksumException {
        this.allocateArrayByteBuffers();
        this.fillDataAndInvalidChecksums();
        this.exception.expect(ChecksumException.class);
        NativeCrc32.verifyChunkedSumsByteArray((int)this.bytesPerChecksum, (int)this.checksumType.id, (byte[])this.checksums.array(), (int)this.checksums.position(), (byte[])this.data.array(), (int)this.data.position(), (int)this.data.remaining(), (String)this.fileName, (long)0L);
    }

    @Test
    public void testCalculateChunkedSumsSuccess() throws ChecksumException {
        this.allocateDirectByteBuffers();
        this.fillDataAndValidChecksums();
        NativeCrc32.calculateChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (ByteBuffer)this.data);
    }

    @Test
    public void testCalculateChunkedSumsFail() throws ChecksumException {
        this.allocateDirectByteBuffers();
        this.fillDataAndInvalidChecksums();
        NativeCrc32.calculateChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (ByteBuffer)this.data);
    }

    @Test
    public void testCalculateChunkedSumsByteArraySuccess() throws ChecksumException {
        this.allocateArrayByteBuffers();
        this.fillDataAndValidChecksums();
        NativeCrc32.calculateChunkedSumsByteArray((int)this.bytesPerChecksum, (int)this.checksumType.id, (byte[])this.checksums.array(), (int)this.checksums.position(), (byte[])this.data.array(), (int)this.data.position(), (int)this.data.remaining());
    }

    @Test
    public void testCalculateChunkedSumsByteArrayFail() throws ChecksumException {
        this.allocateArrayByteBuffers();
        this.fillDataAndInvalidChecksums();
        NativeCrc32.calculateChunkedSumsByteArray((int)this.bytesPerChecksum, (int)this.checksumType.id, (byte[])this.checksums.array(), (int)this.checksums.position(), (byte[])this.data.array(), (int)this.data.position(), (int)this.data.remaining());
    }

    @Test
    public void testNativeVerifyChunkedSumsSuccess() throws ChecksumException {
        this.allocateDirectByteBuffers();
        this.fillDataAndValidChecksums();
        NativeCrc32.nativeVerifyChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (int)this.checksums.position(), (ByteBuffer)this.data, (int)this.data.position(), (int)this.data.remaining(), (String)this.fileName, (long)0L);
    }

    @Test
    public void testNativeVerifyChunkedSumsFail() throws ChecksumException {
        this.allocateDirectByteBuffers();
        this.fillDataAndInvalidChecksums();
        this.exception.expect(ChecksumException.class);
        NativeCrc32.nativeVerifyChunkedSums((int)this.bytesPerChecksum, (int)this.checksumType.id, (ByteBuffer)this.checksums, (int)this.checksums.position(), (ByteBuffer)this.data, (int)this.data.position(), (int)this.data.remaining(), (String)this.fileName, (long)0L);
    }

    private void allocateArrayByteBuffers() {
        this.data = ByteBuffer.wrap(new byte[this.bytesPerChecksum * 3]);
        this.checksums = ByteBuffer.wrap(new byte[3 * this.checksumType.size]);
    }

    private void allocateDirectByteBuffers() {
        this.data = ByteBuffer.allocateDirect(this.bytesPerChecksum * 3);
        this.checksums = ByteBuffer.allocateDirect(3 * this.checksumType.size);
    }

    private void fillDataAndValidChecksums() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.bytesPerChecksum; ++j) {
                byte b = (byte)(i * this.bytesPerChecksum + j & 0xFF);
                this.data.put(b);
                this.checksum.update((int)b);
            }
            this.checksums.putInt((int)this.checksum.getValue());
            this.checksum.reset();
        }
        this.data.flip();
        this.checksums.flip();
    }

    private void fillDataAndInvalidChecksums() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.bytesPerChecksum; ++j) {
                byte b = (byte)(i * this.bytesPerChecksum + j & 0xFF);
                this.data.put(b);
                this.checksum.update((int)((byte)(b + 1)));
            }
            this.checksums.putInt((int)this.checksum.getValue());
            this.checksum.reset();
        }
        this.data.flip();
        this.checksums.flip();
    }
}

