/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFsShellTouch {
    static final Logger LOG = LoggerFactory.getLogger(TestFsShellTouch.class);
    static FsShell shell;
    static LocalFileSystem lfs;
    static Path testRootDir;

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        testRootDir = lfs.makeQualified(new Path(GenericTestUtils.getTempPath("testFsShell")));
        lfs.mkdirs(testRootDir);
        lfs.setWorkingDirectory(testRootDir);
    }

    @Before
    public void prepFiles() throws Exception {
        lfs.setVerifyChecksum(true);
        lfs.setWriteChecksum(true);
    }

    private int shellRun(String ... args) throws Exception {
        int exitCode = shell.run(args);
        LOG.info("exit " + exitCode + " - " + StringUtils.join((CharSequence)" ", (String[])args));
        return exitCode;
    }

    @Test
    public void testTouchz() throws Exception {
        String newFileName = "newFile";
        Path newFile = new Path("newFile");
        lfs.delete(newFile, true);
        Assert.assertThat((Object)lfs.exists(newFile), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Expected successful touchz on a new file", (Object)this.shellRun("-touchz", "newFile"), (Matcher)CoreMatchers.is((Object)0));
        this.shellRun("-ls", "newFile");
        Assert.assertThat((String)"Expected successful touchz on an existing zero-length file", (Object)this.shellRun("-touchz", "newFile"), (Matcher)CoreMatchers.is((Object)0));
        String noDirName = "noDir";
        Path noDir = new Path("noDir");
        lfs.delete(noDir, true);
        Assert.assertThat((Object)lfs.exists(noDir), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Expected failed touchz in a non-existent directory", (Object)this.shellRun("-touchz", "noDir/foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
    }
}

