/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import junit.util.StringUtil;

class TraceFrame
extends JFrame {
    private JButton fButton = null;
    private JTextArea fTextArea = null;

    public TraceFrame() {
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setBackground(SystemColor.control);
        ((Component)this).setSize(500, 250);
        this.setTitle("Stack Trace");
        this.fTextArea = new JTextArea();
        this.fTextArea.setRows(10);
        this.fTextArea.setColumns(60);
        this.fTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.fTextArea);
        this.fButton = new JButton("Close");
        this.fButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TraceFrame.this.dispose();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fButton, gridBagConstraints2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TraceFrame.this.dispose();
            }
        });
    }

    public void showTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuffer stringBuffer = stringWriter.getBuffer();
        this.fTextArea.setText(StringUtil.truncate(stringBuffer.toString(), 5000));
        this.fTextArea.select(0, 0);
    }
}

