/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.builtin.SampleLoader;

public class PoissonSampleLoader
extends SampleLoader {
    public static final String NUMROWS_TUPLE_MARKER = "\u4956\u3838_pig_inTeRnal-spEcial_roW_num_tuple3kt579CFLehkblah";
    private int numRowsSampled = 0;
    private long avgTupleMemSz = 0L;
    private long rowNum = 0L;
    private long skipInterval = -1L;
    private long memToSkipPerSample = 0L;
    private boolean numRowSplTupleReturned = false;
    private static final int DEFAULT_SAMPLE_RATE = 17;
    private int sampleRate = 17;
    private long totalMemory;
    private double heapPerc = 0.3f;
    private Tuple newSample = null;

    public PoissonSampleLoader(String funcSpec, String ns) {
        super(funcSpec);
        super.setNumSamples(Integer.valueOf(ns));
    }

    @Override
    public Tuple getNext() throws IOException {
        if (this.numRowSplTupleReturned) {
            return null;
        }
        if (this.skipInterval == -1L) {
            Tuple t = this.loader.getNext();
            if (t == null) {
                return null;
            }
            long availRedMem = (long)((double)this.totalMemory * this.heapPerc);
            this.memToSkipPerSample = availRedMem / (long)this.sampleRate;
            this.updateSkipInterval(t);
            ++this.rowNum;
            this.newSample = t;
        }
        for (long numSkipped = 0L; numSkipped < this.skipInterval; ++numSkipped) {
            if (!this.skipNext()) {
                return this.createNumRowTuple(this.newSample);
            }
            ++this.rowNum;
        }
        Tuple t = this.loader.getNext();
        if (t == null) {
            return this.createNumRowTuple(this.newSample);
        }
        this.updateSkipInterval(t);
        ++this.rowNum;
        Tuple currentSample = this.newSample;
        this.newSample = t;
        return currentSample;
    }

    private void updateSkipInterval(Tuple t) {
        this.avgTupleMemSz = (this.avgTupleMemSz * (long)this.numRowsSampled + t.getMemorySize()) / (long)(this.numRowsSampled + 1);
        this.skipInterval = this.memToSkipPerSample / this.avgTupleMemSz;
        if (this.numRowsSampled < 5) {
            this.skipInterval /= (long)(10 - this.numRowsSampled);
        }
        ++this.numRowsSampled;
    }

    private Tuple createNumRowTuple(Tuple sample) throws ExecException {
        int sz = sample == null ? 0 : sample.size();
        TupleFactory factory = TupleFactory.getInstance();
        Tuple t = factory.newTuple(sz + 2);
        if (sample != null) {
            for (int i = 0; i < sample.size(); ++i) {
                t.set(i, sample.get(i));
            }
        }
        t.set(sz, NUMROWS_TUPLE_MARKER);
        t.set(sz + 1, this.rowNum);
        this.numRowSplTupleReturned = true;
        return t;
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        super.prepareToRead(reader, split);
        this.numRowsSampled = 0;
        this.avgTupleMemSz = 0L;
        this.rowNum = 0L;
        this.skipInterval = -1L;
        this.memToSkipPerSample = 0L;
        this.numRowSplTupleReturned = false;
        this.newSample = null;
        Configuration conf = split.getConf();
        this.sampleRate = conf.getInt("pig.sksampler.samplerate", 17);
        this.heapPerc = conf.getFloat("pig.skewedjoin.reduce.memusage", 0.3f);
        this.totalMemory = conf.getLong("pig.skewedjoin.reduce.mem", -1L);
        if (this.totalMemory == -1L) {
            this.totalMemory = Runtime.getRuntime().maxMemory();
        }
    }
}

