/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.bloom;

import org.apache.pig.impl.bloom.JenkinsHash;
import org.apache.pig.impl.bloom.KirschMitzenmacherHash;
import org.apache.pig.impl.bloom.Murmur3Hash;

public abstract class Hash {
    public static final int MURMUR = 1;
    public static final int MURMUR3 = 1;
    public static final int MURMUR3KM = 2;
    public static final int JENKINS = 3;

    public static int parseHashType(String hashType) {
        if ("murmur".equalsIgnoreCase(hashType)) {
            return 1;
        }
        if ("murmur3km".equalsIgnoreCase(hashType)) {
            return 2;
        }
        if ("jenkins".equalsIgnoreCase(hashType)) {
            return 3;
        }
        throw new IllegalArgumentException("Hash Algorithm values must be one of - murmur, murmur3km, jenkins");
    }

    public static Hash getInstance(int hashType) {
        switch (hashType) {
            case 1: {
                return new Murmur3Hash();
            }
            case 2: {
                return new KirschMitzenmacherHash();
            }
            case 3: {
                return new JenkinsHash();
            }
        }
        throw new IllegalArgumentException("Hash type values must be one of - 1 (murmur), 2 (murmur3km), 3 (jenkins)");
    }

    public abstract int[] hash(byte[] var1, int var2, int var3);
}

