/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.HashMap;
import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class KeyTypeDiscoveryVisitor
extends MROpPlanVisitor {
    public KeyTypeDiscoveryVisitor(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        List<MapReduceOper> preds;
        if (mr instanceof NativeMapReduceOper) {
            return;
        }
        if (mr.useSecondaryKey) {
            mr.mapKeyType = (byte)110;
            return;
        }
        boolean foundKeyType = false;
        PhyPlanKeyTypeVisitor kvisitor = new PhyPlanKeyTypeVisitor(mr.mapPlan, mr);
        kvisitor.visit();
        if (!kvisitor.foundKeyType && (preds = ((MROperPlan)this.mPlan).getPredecessors(mr)) != null) {
            String message;
            HashMap<Byte, Integer> seen = new HashMap<Byte, Integer>();
            for (MapReduceOper pred : preds) {
                PhyPlanKeyTypeVisitor visitor = new PhyPlanKeyTypeVisitor(pred.reducePlan, mr);
                visitor.visit();
                foundKeyType |= visitor.foundKeyType;
                byte type = mr.mapKeyType;
                seen.put(type, 1);
            }
            if (seen.size() > 1) {
                int errorCode = 2119;
                message = "Internal Error: Found multiple data types for map key";
                throw new VisitorException(message, errorCode, 4);
            }
            if (!foundKeyType && !mr.reducePlan.isEmpty()) {
                int errorCode = 2120;
                message = "Internal Error: Unable to determine data type for map key";
                throw new VisitorException(message, errorCode, 4);
            }
        }
    }

    static class PhyPlanKeyTypeVisitor
    extends PhyPlanVisitor {
        private MapReduceOper mro;
        private boolean foundKeyType = false;

        public PhyPlanKeyTypeVisitor(PhysicalPlan plan, MapReduceOper mro) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.mro = mro;
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lr) throws VisitorException {
            this.mro.mapKeyType = lr.getKeyType();
            this.foundKeyType = true;
        }
    }
}

