/*
 * Decompiled with CFR 0.152.
 */
package opennlp.morfologik.lemmatizer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import opennlp.tools.lemmatizer.Lemmatizer;

public class MorfologikLemmatizer
implements Lemmatizer {
    private final Dictionary dictionary;

    public MorfologikLemmatizer(Path dictionaryPath) throws IOException {
        this(Dictionary.read((Path)dictionaryPath));
    }

    public MorfologikLemmatizer(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    private List<String> lemmatize(String word, String postag) {
        List dictMap = new DictionaryLookup(this.dictionary).lookup((CharSequence)word.toLowerCase());
        HashSet<String> lemmas = new HashSet<String>();
        for (WordData wordData : dictMap) {
            if (!Objects.equals(postag, this.asString(wordData.getTag()))) continue;
            lemmas.add(this.asString(wordData.getStem()));
        }
        return List.copyOf(lemmas);
    }

    private String asString(CharSequence tag) {
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public String[] lemmatize(String[] toks, String[] tags) {
        String[] lemmas = new String[toks.length];
        for (int i = 0; i < toks.length; ++i) {
            List<String> l = this.lemmatize(toks[i], tags[i]);
            lemmas[i] = l.size() > 0 ? l.get(0) : null;
        }
        return lemmas;
    }

    public List<List<String>> lemmatize(List<String> toks, List<String> tags) {
        ArrayList<List<String>> lemmas = new ArrayList<List<String>>();
        for (int i = 0; i < toks.size(); ++i) {
            lemmas.add(this.lemmatize(toks.get(i), tags.get(i)));
        }
        return lemmas;
    }
}

