/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.sentdetect.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.model.ModelUtil;

public final class SentenceDetectorTrainerTool
extends AbstractTrainerTool<SentenceSample, TrainerToolParams> {
    public SentenceDetectorTrainerTool() {
        super(SentenceSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Trainer for the learnable sentence detector";
    }

    static Dictionary loadDict(File f) throws IOException {
        Dictionary dict = null;
        if (f != null) {
            CmdLineUtil.checkInputFile("abb dict", f);
            dict = new Dictionary(new BufferedInputStream(new FileInputStream(f)));
        }
        return dict;
    }

    @Override
    public void run(String format, String[] args) {
        SentenceModel model;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams != null && !TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)TrainerFactory.getTrainerType(this.mlParams))) {
            throw new TerminateToolException(1, "Sequence training is not supported!");
        }
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("sentence detector model", modelOutFile);
        char[] eos = null;
        if (((TrainerToolParams)this.params).getEosChars() != null) {
            String eosString = SentenceSampleStream.replaceNewLineEscapeTags(((TrainerToolParams)this.params).getEosChars());
            eos = eosString.toCharArray();
        }
        try {
            Dictionary dict = SentenceDetectorTrainerTool.loadDict(((TrainerToolParams)this.params).getAbbDict());
            SentenceDetectorFactory sdFactory = SentenceDetectorFactory.create(((TrainerToolParams)this.params).getFactory(), ((TrainerToolParams)this.params).getLang(), ((TrainerToolParams)this.params).getUseTokenEnd(), dict, eos);
            model = SentenceDetectorME.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, sdFactory, this.mlParams);
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("sentence detector", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

