/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kurento.jsonrpc.DefaultJsonRpcHandler;
import org.kurento.jsonrpc.JsonRpcAndJavaMethodManager;
import org.kurento.jsonrpc.JsonRpcMethod;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TypeDefaultJsonRpcHandler
extends DefaultJsonRpcHandler<JsonObject> {
    private final Logger log = LoggerFactory.getLogger(TypeDefaultJsonRpcHandler.class);
    private final Map<String, Method> methods = new ConcurrentHashMap<String, Method>();
    private static final JsonRpcAndJavaMethodManager methodManager = new JsonRpcAndJavaMethodManager();

    public TypeDefaultJsonRpcHandler() {
        Method[] methodsArray;
        for (Method method : methodsArray = this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(JsonRpcMethod.class)) continue;
            this.methods.put(method.getName(), method);
        }
    }

    @Override
    public void handleRequest(Transaction transaction, Request<JsonObject> request) throws Exception {
        try {
            Method method = this.methods.get(request.getMethod());
            if (method == null) {
                this.log.error("Requesting unrecognized method '{}'", (Object)request.getMethod());
                transaction.sendError(1, "UNRECOGNIZED_METHOD", "Unrecognized method '" + request.getMethod() + "'", null);
            } else {
                methodManager.executeMethod(method, this, transaction, request);
            }
        }
        catch (Exception e) {
            this.log.error("Exception processing request {}", request, (Object)e);
            transaction.sendError(e);
        }
    }
}

