/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload.resource;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxUtils;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.form.upload.resource.FileUploadResourceReference;
import org.apache.wicket.markup.html.form.upload.resource.IUploadsFileManager;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.Strings;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUploadToResourceField
extends FileUploadField {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadToResourceField.class);
    private static final JavaScriptResourceReference JS = new JavaScriptResourceReference(FileUploadToResourceField.class, "FileUploadToResourceField.js");
    public static String UPLOAD_CANCELED = "upload.canceled";
    private final AbstractDefaultAjaxBehavior ajaxBehavior;
    private transient List<UploadInfo> fileUploadInfos;
    private Bytes fileMaxSize;
    private long fileCountMax = -1L;
    private Bytes maxSize = null;

    public FileUploadToResourceField(String id) {
        super(id);
        this.setOutputMarkupId(true);
        this.setMarkupId(this.generateAUniqueApplicationWiseId());
        this.setDefaultModel((IModel)new FileModel(){

            @Override
            protected IUploadsFileManager fileManager() {
                return FileUploadToResourceField.this.fileManager();
            }

            @Override
            protected String getUploadFieldId() {
                return FileUploadToResourceField.this.getMarkupId();
            }

            @Override
            protected List<UploadInfo> getFileUploadInfos() {
                return FileUploadToResourceField.this.fileUploadInfos;
            }
        });
        this.ajaxBehavior = new AbstractDefaultAjaxBehavior(){

            @Override
            protected void respond(AjaxRequestTarget target) {
                Request request = RequestCycle.get().getRequest();
                boolean error = request.getRequestParameters().getParameterValue("error").toBoolean(true);
                if (!error) {
                    String filesIfo = request.getRequestParameters().getParameterValue("filesInfo").toString();
                    FileUploadToResourceField.this.fileUploadInfos = UploadInfo.fromJson(filesIfo);
                    FileUploadToResourceField.this.onUploadSuccess(target, FileUploadToResourceField.this.getFileUploadInfos());
                } else {
                    String errorMessage = request.getRequestParameters().getParameterValue("errorMessage").toString(null);
                    if (UPLOAD_CANCELED.equals(errorMessage)) {
                        FileUploadToResourceField.this.onUploadCanceled(target);
                    } else {
                        if ("wicket.no.files.selected".equals(errorMessage)) {
                            errorMessage = FileUploadToResourceField.this.getString("wicket.no.files.selected");
                        } else {
                            HashMap<String, Object> model = new HashMap<String, Object>();
                            if (Strings.isEmpty((String)errorMessage)) {
                                errorMessage = "uploadTooLarge";
                            }
                            model.put("exception", errorMessage);
                            model.put("maxSize", FileUploadToResourceField.this.getMaxSize());
                            model.put("fileMaxSize", FileUploadToResourceField.this.getFileMaxSize());
                            model.put("fileCountMax", FileUploadToResourceField.this.getFileCountMax());
                            errorMessage = FileUploadToResourceField.this.getString(errorMessage, Model.ofMap(model));
                        }
                        FileUploadToResourceField.this.error((Serializable)((Object)errorMessage));
                        FileUploadToResourceField.this.onUploadFailure(target, errorMessage);
                    }
                }
            }
        };
        this.add(this.ajaxBehavior);
    }

    private List<UploadInfo> getFileUploadInfos() {
        return (List)this.getDefaultModel().getObject();
    }

    @Override
    public FileUpload getFileUpload() {
        throw new UnsupportedOperationException("FileUploadToResourceField does not support working with FileUpload");
    }

    @Override
    public List<FileUpload> getFileUploads() {
        throw new UnsupportedOperationException("FileUploadToResourceField does not support working with FileUpload");
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        AjaxUtils.executeIfAjaxOrWebSockets((SerializableConsumer<IPartialPageRequestHandler>)(SerializableConsumer & Serializable)target -> target.appendJavaScript("delete Wicket.Timer." + this.getMarkupId() + ";"));
    }

    protected abstract void onUploadSuccess(AjaxRequestTarget var1, List<UploadInfo> var2);

    protected void onUploadFailure(AjaxRequestTarget target, String errorInfo) {
    }

    protected void onUploadCanceled(AjaxRequestTarget target) {
    }

    protected String generateAUniqueApplicationWiseId() {
        return "WRFUF_" + UUID.randomUUID().toString().replace("-", "_");
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        CoreLibrariesContributor.contributeAjax(this.getApplication(), response);
        response.render(JavaScriptHeaderItem.forReference(JS));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("inputName", (Object)this.getMarkupId());
        jsonObject.put("resourceUrl", (Object)this.urlFor(this.getFileUploadResourceReference(), new PageParameters()).toString());
        jsonObject.put("ajaxCallBackUrl", (Object)this.ajaxBehavior.getCallbackUrl());
        jsonObject.put("maxSize", this.getMaxSize().bytes());
        Bytes fileMaxSize = this.getFileMaxSize();
        if (fileMaxSize != null) {
            jsonObject.put("fileMaxSize", fileMaxSize.bytes());
        }
        jsonObject.put("fileCountMax", this.getFileCountMax());
        response.render(OnDomReadyHeaderItem.forScript("Wicket.Timer." + this.getMarkupId() + " = new Wicket.FileUploadToResourceField(" + String.valueOf(jsonObject) + "," + String.valueOf(this.getClientBeforeSendCallBack()) + "," + String.valueOf(this.getClientSideSuccessCallBack()) + "," + String.valueOf(this.getClientSideCancelCallBack()) + "," + String.valueOf(this.getClientSideUploadErrorCallBack()) + ");"));
    }

    public void setFileMaxSize(Bytes fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public void setFileCountMax(long fileCountMax) {
        this.fileCountMax = fileCountMax;
    }

    public void setMaxSize(Bytes maxSize) {
        this.maxSize = maxSize;
    }

    public final Bytes getMaxSize() {
        if (this.maxSize == null) {
            return this.getApplication().getApplicationSettings().getDefaultMaximumUploadSize();
        }
        return this.maxSize;
    }

    public Bytes getFileMaxSize() {
        return this.fileMaxSize;
    }

    public long getFileCountMax() {
        return this.fileCountMax;
    }

    protected FileUploadResourceReference getFileUploadResourceReference() {
        return FileUploadResourceReference.getInstance();
    }

    public String getTriggerUploadScript() {
        return "Wicket.Timer." + this.getMarkupId() + ".upload();";
    }

    public void startUpload(IPartialPageRequestHandler target) {
        target.appendJavaScript(this.getTriggerUploadScript());
    }

    public String getTriggerCancelUploadScript() {
        return "Wicket.Timer." + this.getMarkupId() + ".cancel();";
    }

    public void cancelUpload(IPartialPageRequestHandler target) {
        target.appendJavaScript(this.getTriggerCancelUploadScript());
    }

    protected CharSequence getClientBeforeSendCallBack() {
        return "function (xhr, settings) { return true; }";
    }

    protected CharSequence getClientSideSuccessCallBack() {
        return "function () {}";
    }

    protected CharSequence getClientSideCancelCallBack() {
        return "function () {}";
    }

    protected CharSequence getClientSideUploadErrorCallBack() {
        return "function (res) {}";
    }

    protected IUploadsFileManager fileManager() {
        return this.getFileUploadResourceReference().getUploadFileManager();
    }

    private static abstract class FileModel
    implements IModel<List<UploadInfo>> {
        private FileModel() {
        }

        @Override
        public List<UploadInfo> getObject() {
            List<UploadInfo> fileInfos = this.getFileUploadInfos();
            for (UploadInfo uploadInfo : fileInfos) {
                uploadInfo.setFile((File)this.fileManager().getFile(this.getUploadFieldId(), uploadInfo.clientFileName));
            }
            return fileInfos;
        }

        @Override
        public void setObject(List<UploadInfo> object) {
            throw new UnsupportedOperationException("setObject not supported");
        }

        protected abstract IUploadsFileManager fileManager();

        protected abstract String getUploadFieldId();

        protected abstract List<UploadInfo> getFileUploadInfos();
    }

    public static final class UploadInfo {
        private File file;
        private final String clientFileName;
        private final long size;
        private final String contentType;

        public UploadInfo(String clientFileName, long size, String contentType) {
            this.clientFileName = clientFileName;
            this.size = size;
            this.contentType = contentType;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getClientFileName() {
            return this.clientFileName;
        }

        public long getSize() {
            return this.size;
        }

        public String getContentType() {
            return this.contentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UploadInfo fileInfo = (UploadInfo)o;
            return Objects.equals(this.clientFileName, fileInfo.clientFileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] get() {
            if (this.file == null) {
                return null;
            }
            byte[] fileData = new byte[(int)this.getSize()];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.file);
                IOUtils.readFully((InputStream)fis, (byte[])fileData);
            }
            catch (IOException e) {
                try {
                    LOGGER.debug("IOException at get", (Throwable)e);
                    fileData = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            return fileData;
        }

        public int hashCode() {
            return Objects.hash(this.clientFileName);
        }

        public static List<UploadInfo> fromJson(String json) {
            ArrayList<UploadInfo> infos = new ArrayList<UploadInfo>();
            JSONArray jsonArray = new JSONArray(json);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                infos.add(new UploadInfo(jsonObject.getString("clientFileName"), jsonObject.getLong("size"), jsonObject.getString("contentType")));
            }
            return infos;
        }
    }
}

