/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.util.Vector;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;

public class Description
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    protected SchemaObjectFactoryInterface f = null;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    public boolean keepAlive = false;
    public String SDU;
    public String TDU;
    public Vector protocolStacks = new Vector();
    protected String useTcpFastOpen;
    public String sendBufSize;
    public String receiveBufSize;
    public String connectData;
    public String SID;
    public String server;
    public String failoverMode;
    public String instanceRole;
    public String serviceName;
    public String instanceName;
    public String handlerName;
    public String oracleHome;
    public String connectTimeout;
    public String transportTimeout;
    public String retryCount;
    public String authTypes;
    public String sslServerCertDN;
    protected String sslServerDNMatch;
    protected String sslAllowWeakDNMatch;
    protected String myWalletDirectory;
    public Vector authParams = new Vector();
    protected String allowWeakCrypto;
    protected String tokenAuthentication;
    protected String tokenLocation;
    protected String passwordAuthentication;
    protected String ociIamUrl;
    protected String ociTenancy;
    protected String ociCompartment;
    protected String ociDatabase;
    public Vector extraConnInfo = new Vector();
    public Vector extraInfo = new Vector();
    protected int delay = -1;

    public Description(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        this.f = schemaObjectFactoryInterface;
    }

    @Override
    public int isA() {
        return 2;
    }

    @Override
    public String isA_String() {
        return "DESCRIPTION";
    }

    @Override
    public void initFromString(String string) throws NLException, SOException, NetException {
        NVPair nVPair = new NVFactory().createNVPair(string);
        this.initFromNVPair(nVPair);
    }

    @Override
    public void initFromNVPair(NVPair nVPair) throws SOException, NetException {
        this.init();
        int n2 = nVPair.getListSize();
        if (n2 == 0) {
            throw new SOException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            NVPair nVPair2;
            int n3;
            this.childnv = nVPair.getListElement(i2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ENABLE")) {
                this.keepAlive = this.childnv.getAtom().equalsIgnoreCase("broken");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("PROTOCOL_STACK")) {
                this.protocolStacks.addElement(this.childnv.toString());
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SDU")) {
                this.SDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TDU")) {
                this.TDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SEND_BUF_SIZE")) {
                this.sendBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RECV_BUF_SIZE")) {
                this.receiveBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_DATA")) {
                this.connectData = this.childnv.valueToString();
                int n4 = this.childnv.getListSize();
                if (n4 == 0) {
                    throw new SOException();
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    nVPair2 = this.childnv.getListElement(n3);
                    if (nVPair2.getName().equalsIgnoreCase("SID")) {
                        this.SID = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("SERVER")) {
                        this.server = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("SERVICE_NAME")) {
                        this.serviceName = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("INSTANCE_NAME")) {
                        this.instanceName = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("HANDLER_NAME")) {
                        this.handlerName = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ORACLE_HOME")) {
                        this.oracleHome = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("FAILOVER_MODE")) {
                        this.failoverMode = this.childnv.getListElement(n3).toString();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("INSTANCE_ROLE")) {
                        this.instanceRole = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("USE_TCP_FAST_OPEN")) {
                        this.setUseTcpFastOpen("USE_TCP_FAST_OPEN", nVPair2.getAtom());
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("TFO")) {
                        this.setUseTcpFastOpen("TFO", nVPair2.getAtom());
                        continue;
                    }
                    String string = nVPair2.toString().trim();
                    string = string.substring(1, string.length() - 1);
                    this.extraConnInfo.addElement(string);
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_DELAY")) {
                this.delay = Integer.parseInt(this.childnv.getAtom());
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SECURITY")) {
                int n5 = this.childnv.getListSize();
                if (n5 == 0) {
                    throw new SOException();
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    nVPair2 = this.childnv.getListElement(n3);
                    if (nVPair2.getName().equalsIgnoreCase("AUTHENTICATION")) {
                        this.authTypes = nVPair2.toString();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_server_cert_dn")) {
                        this.sslServerCertDN = nVPair2.getAtom();
                        if (this.sslServerCertDN == null || !this.sslServerCertDN.startsWith("\"") || !this.sslServerCertDN.endsWith("\"")) continue;
                        this.sslServerCertDN = this.sslServerCertDN.substring(1, this.sslServerCertDN.length() - 1);
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_server_dn_match")) {
                        this.sslServerDNMatch = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("ssl_allow_weak_dn_match")) {
                        this.sslAllowWeakDNMatch = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("wallet_location")) {
                        this.myWalletDirectory = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("my_wallet_directory") && this.myWalletDirectory == null) {
                        this.myWalletDirectory = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("allow_weak_crypto")) {
                        this.allowWeakCrypto = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("token_auth")) {
                        this.tokenAuthentication = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("token_location")) {
                        this.tokenLocation = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("password_auth")) {
                        this.passwordAuthentication = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_iam_url")) {
                        this.ociIamUrl = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_tenancy")) {
                        this.ociTenancy = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_compartment")) {
                        this.ociCompartment = nVPair2.getAtom();
                        continue;
                    }
                    if (nVPair2.getName().equalsIgnoreCase("oci_database")) {
                        this.ociDatabase = nVPair2.getAtom();
                        continue;
                    }
                    this.authParams.addElement(nVPair2.toString());
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_TIMEOUT")) {
                this.connectTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TRANSPORT_CONNECT_TIMEOUT")) {
                this.transportTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_COUNT")) {
                this.retryCount = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("HS") && this.childnv.getAtom() == null) {
                try {
                    this.childnv.setAtom("OK");
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            String string = this.childnv.toString().trim();
            string = string.substring(1, string.length() - 1);
            this.extraInfo.addElement(string);
        }
    }

    private void setUseTcpFastOpen(String string, String string2) throws NetException {
        if (!SQLnetDef.isValidTcpFastOpenValue(string2)) {
            throw new NetException(127, null, false, string, string2);
        }
        this.useTcpFastOpen = string2;
    }

    @Override
    @DisableTrace
    public String toString() {
        int n2;
        Object object = new String("");
        String string = new String("");
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            string = ((SchemaObject)this.children.elementAt(n2)).toString();
            if (string.equals("")) continue;
            object = (String)object + string;
        }
        if (!((String)object).equals("") && this.sourceRoute) {
            object = (String)object + "(SOURCE_ROUTE=yes)";
        }
        if (!((String)object).equals("") && this.loadBalance) {
            object = (String)object + "(LOAD_BALANCE=yes)";
        }
        if (!((String)object).equals("") && !this.failover) {
            object = (String)object + "(FAILOVER=false)";
        }
        if (this.keepAlive) {
            object = (String)object + "(ENABLE=broken)";
        }
        if (this.SDU != null) {
            object = (String)object + "(SDU=" + this.SDU + ")";
        }
        if (this.TDU != null) {
            object = (String)object + "(TDU=" + this.TDU + ")";
        }
        if (this.sendBufSize != null) {
            object = (String)object + "(SEND_BUF_SIZE=" + this.sendBufSize + ")";
        }
        if (this.receiveBufSize != null) {
            object = (String)object + "(RECV_BUF_SIZE=" + this.receiveBufSize + ")";
        }
        if (this.protocolStacks.size() != 0) {
            for (n2 = 0; n2 < this.protocolStacks.size(); ++n2) {
                object = (String)object + (String)this.protocolStacks.elementAt(n2);
            }
        }
        if (this.SID != null || this.server != null || this.serviceName != null || this.instanceName != null || this.handlerName != null || this.extraConnInfo.size() != 0 || this.oracleHome != null) {
            object = (String)object + "(CONNECT_DATA=";
            if (this.SID != null) {
                object = (String)object + "(SID=" + this.SID + ")";
            }
            if (this.server != null) {
                object = (String)object + "(SERVER=" + this.server + ")";
            }
            if (this.serviceName != null) {
                object = (String)object + "(SERVICE_NAME=" + this.serviceName + ")";
            }
            if (this.instanceName != null) {
                object = (String)object + "(INSTANCE_NAME=" + this.instanceName + ")";
            }
            if (this.handlerName != null) {
                object = (String)object + "(HANDLER_NAME=" + this.handlerName + ")";
            }
            if (this.oracleHome != null) {
                object = (String)object + "(ORACLE_HOME=" + this.oracleHome + ")";
            }
            if (this.instanceRole != null) {
                object = (String)object + "(INSTANCE_ROLE=" + this.instanceRole + ")";
            }
            if (this.failoverMode != null) {
                object = (String)object + this.failoverMode;
            }
            for (n2 = 0; n2 < this.extraConnInfo.size(); ++n2) {
                object = (String)object + "(" + (String)this.extraConnInfo.elementAt(n2) + ")";
            }
            object = (String)object + ")";
        }
        if (this.authTypes != null || this.authParams.size() != 0) {
            object = (String)object + "(SECURITY=";
            if (this.authTypes != null) {
                object = (String)object + "(AUTHENTICATION=" + this.authTypes + ")";
            }
            for (n2 = 0; n2 < this.authParams.size(); ++n2) {
                object = (String)object + (String)this.authParams.elementAt(n2);
            }
            object = (String)object + ")";
        }
        for (n2 = 0; n2 < this.extraInfo.size(); ++n2) {
            object = (String)object + "(" + (String)this.extraInfo.elementAt(n2) + ")";
        }
        if (!((String)object).equals("")) {
            object = "(DESCRIPTION=" + (String)object + ")";
        }
        return object;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
        this.keepAlive = false;
        this.protocolStacks.removeAllElements();
        this.SDU = null;
        this.TDU = null;
        this.SID = null;
        this.server = null;
        this.serviceName = null;
        this.instanceName = null;
        this.handlerName = null;
        this.oracleHome = null;
        this.authTypes = null;
        this.sendBufSize = null;
        this.receiveBufSize = null;
        this.failoverMode = null;
        this.instanceRole = null;
        this.authParams.removeAllElements();
        this.extraConnInfo.removeAllElements();
        this.extraInfo.removeAllElements();
    }
}

