/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.internal.management.events.Event;

public final class MCEventDTO {
    private final long timestamp;
    private final int type;
    private final String dataJson;

    public MCEventDTO(long timestamp, int type, String dataJson) {
        this.timestamp = timestamp;
        this.type = type;
        this.dataJson = dataJson;
    }

    public static MCEventDTO fromEvent(Event event) {
        return new MCEventDTO(event.getTimestamp(), event.getType().getCode(), event.toJson().toString());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getType() {
        return this.type;
    }

    public String getDataJson() {
        return this.dataJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCEventDTO eventDTO = (MCEventDTO)o;
        if (this.timestamp != eventDTO.timestamp) {
            return false;
        }
        if (this.type != eventDTO.type) {
            return false;
        }
        return this.dataJson.equals(eventDTO.dataJson);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.type;
        result = 31 * result + this.dataJson.hashCode();
        return result;
    }
}

