/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;

class ApplyRequestValuesExecutor
extends PhaseExecutor {
    private ViewPoolProcessor viewPoolProcessor;
    private boolean initialized = false;

    ApplyRequestValuesExecutor() {
    }

    @Override
    public boolean execute(FacesContext facesContext) {
        if (facesContext.getViewRoot() == null) {
            throw new ViewNotFoundException("A view is required to execute " + String.valueOf(facesContext.getCurrentPhaseId()));
        }
        facesContext.getViewRoot().processDecodes(facesContext);
        ViewPoolProcessor processor = this.getViewPoolProcessor(facesContext);
        if (processor != null) {
            processor.processDeferredNavigation(facesContext);
        }
        return false;
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.APPLY_REQUEST_VALUES;
    }

    private ViewPoolProcessor getViewPoolProcessor(FacesContext context) {
        if (!this.initialized) {
            this.viewPoolProcessor = ViewPoolProcessor.getInstance(context);
            this.initialized = true;
        }
        return this.viewPoolProcessor;
    }
}

