/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditFiltersMode;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditParamsDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditParamsMode;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.CustomAnalyzerPanelOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.app.desktop.util.lang.Callable;

public final class EditFiltersDialogFactory
implements DialogOpener.DialogFactory {
    private static EditFiltersDialogFactory instance;
    private final Preferences prefs;
    private final ComponentOperatorRegistry operatorRegistry;
    private final EditParamsDialogFactory editParamsDialogFactory;
    private final JLabel targetLbl = new JLabel();
    private final JTable filtersTable = new JTable();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private final FiltersTableMouseListener tableListener = new FiltersTableMouseListener();
    private JDialog dialog;
    private List<String> selectedFilters;
    private Callable callback;
    private EditFiltersMode mode;

    public static synchronized EditFiltersDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new EditFiltersDialogFactory();
        }
        return instance;
    }

    private EditFiltersDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.editParamsDialogFactory = EditParamsDialogFactory.getInstance();
    }

    public void setSelectedFilters(List<String> selectedFilters) {
        this.selectedFilters = selectedFilters;
    }

    public void setCallback(Callable callback) {
        this.callback = callback;
    }

    public void setMode(EditFiltersMode mode) {
        this.mode = mode;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel header = new JPanel(new FlowLayout(3, 10, 10));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("analysis.dialog.hint.edit_param")));
        header.add(this.targetLbl);
        panel.add((Component)header, "First");
        TableUtils.setupTable(this.filtersTable, 0, new FiltersTableModel(this.selectedFilters), this.tableListener, FiltersTableModel.Column.DELETE.getColumnWidth(), FiltersTableModel.Column.ORDER.getColumnWidth());
        this.filtersTable.setShowGrid(true);
        this.filtersTable.getColumnModel().getColumn(FiltersTableModel.Column.TYPE.getIndex()).setCellRenderer(new TypeCellRenderer());
        panel.add((Component)new JScrollPane(this.filtersTable), "Center");
        JPanel footer = new JPanel(new FlowLayout(4, 10, 5));
        footer.setOpaque(false);
        JButton okBtn = new JButton(MessageUtils.getLocalizedMessage("button.ok"));
        okBtn.addActionListener(e -> {
            ArrayList<Integer> deletedIndexes = new ArrayList<Integer>();
            for (int i = 0; i < this.filtersTable.getRowCount(); ++i) {
                boolean deleted = (Boolean)this.filtersTable.getValueAt(i, FiltersTableModel.Column.DELETE.getIndex());
                if (!deleted) continue;
                deletedIndexes.add(i);
            }
            this.operatorRegistry.get(CustomAnalyzerPanelOperator.class).ifPresent(operator -> {
                switch (this.mode) {
                    case CHARFILTER: {
                        operator.updateCharFilters(deletedIndexes);
                        break;
                    }
                    case TOKENFILTER: {
                        operator.updateTokenFilters(deletedIndexes);
                    }
                }
            });
            this.callback.call();
            this.dialog.dispose();
        });
        footer.add(okBtn);
        JButton cancelBtn = new JButton(MessageUtils.getLocalizedMessage("button.cancel"));
        cancelBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(cancelBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }

    static final class TypeCellRenderer
    implements TableCellRenderer {
        TypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String[] tmp = ((String)value).split("\\.");
            String type = tmp[tmp.length - 1];
            return new JLabel(type);
        }
    }

    static final class FiltersTableModel
    extends TableModelBase<Column> {
        FiltersTableModel() {
        }

        FiltersTableModel(List<String> selectedFilters) {
            super(selectedFilters.size());
            for (int i = 0; i < selectedFilters.size(); ++i) {
                this.data[i][Column.DELETE.getIndex()] = false;
                this.data[i][Column.ORDER.getIndex()] = i + 1;
                this.data[i][Column.TYPE.getIndex()] = selectedFilters.get(i);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == Column.DELETE.getIndex();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            DELETE("Delete", 0, Boolean.class, 50),
            ORDER("Order", 1, Integer.class, 50),
            TYPE("Factory class", 2, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private class FiltersTableMouseListener
    extends MouseAdapter {
        private FiltersTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            EditFiltersDialogFactory.this.listeners.showEditParamsDialog(e);
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void showEditParamsDialog(MouseEvent e) {
            if (e.getClickCount() != 2 || e.isConsumed()) {
                return;
            }
            int selectedIndex = EditFiltersDialogFactory.this.filtersTable.rowAtPoint(e.getPoint());
            if (selectedIndex < 0 || selectedIndex >= EditFiltersDialogFactory.this.selectedFilters.size()) {
                return;
            }
            switch (EditFiltersDialogFactory.this.mode) {
                case CHARFILTER: {
                    this.showEditParamsCharFilterDialog(selectedIndex);
                    break;
                }
                case TOKENFILTER: {
                    this.showEditParamsTokenFilterDialog(selectedIndex);
                    break;
                }
            }
        }

        private void showEditParamsCharFilterDialog(int selectedIndex) {
            int targetIndex = EditFiltersDialogFactory.this.filtersTable.getSelectedRow();
            String selectedItem = (String)EditFiltersDialogFactory.this.filtersTable.getValueAt(selectedIndex, FiltersTableModel.Column.TYPE.getIndex());
            Map params = EditFiltersDialogFactory.this.operatorRegistry.get(CustomAnalyzerPanelOperator.class).map(operator -> operator.getCharFilterParams(targetIndex)).orElse(Collections.emptyMap());
            new DialogOpener<EditParamsDialogFactory>(EditFiltersDialogFactory.this.editParamsDialogFactory).open(EditFiltersDialogFactory.this.dialog, MessageUtils.getLocalizedMessage("analysis.dialog.title.char_filter_params"), 400, 300, factory -> {
                factory.setMode(EditParamsMode.CHARFILTER);
                factory.setTargetIndex(targetIndex);
                factory.setTarget(selectedItem);
                factory.setParams(params);
            }, new String[0]);
        }

        private void showEditParamsTokenFilterDialog(int selectedIndex) {
            int targetIndex = EditFiltersDialogFactory.this.filtersTable.getSelectedRow();
            String selectedItem = (String)EditFiltersDialogFactory.this.filtersTable.getValueAt(selectedIndex, FiltersTableModel.Column.TYPE.getIndex());
            Map params = EditFiltersDialogFactory.this.operatorRegistry.get(CustomAnalyzerPanelOperator.class).map(operator -> operator.getTokenFilterParams(targetIndex)).orElse(Collections.emptyMap());
            new DialogOpener<EditParamsDialogFactory>(EditFiltersDialogFactory.this.editParamsDialogFactory).open(EditFiltersDialogFactory.this.dialog, MessageUtils.getLocalizedMessage("analysis.dialog.title.char_filter_params"), 400, 300, factory -> {
                factory.setMode(EditParamsMode.TOKENFILTER);
                factory.setTargetIndex(targetIndex);
                factory.setTarget(selectedItem);
                factory.setParams(params);
            }, new String[0]);
        }
    }
}

