/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.weaver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.weaver.LocationCacheGenerator;
import org.apache.logging.log4j.weaver.LocationClassVisitor;
import org.apache.logging.log4j.weaver.log4j2.LogBuilderConversionHandler;
import org.apache.logging.log4j.weaver.log4j2.LoggerConversionHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class LocationClassConverter {
    private final ClassLoader classpath;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LocationClassConverter(ClassLoader classpath) {
        this.classpath = classpath;
    }

    public void convert(InputStream src, OutputStream dest, LocationCacheGenerator locationCache) throws IOException {
        PrivateClassWriter writer = new PrivateClassWriter(2, this.classpath);
        LocationClassVisitor converter = new LocationClassVisitor((ClassVisitor)writer, locationCache);
        converter.addClassConversionHandler(new LoggerConversionHandler());
        converter.addClassConversionHandler(new LogBuilderConversionHandler());
        new ClassReader(src).accept((ClassVisitor)converter, 8);
        dest.write(writer.toByteArray());
    }

    private static class PrivateClassWriter
    extends ClassWriter {
        private final ClassLoader classpath;

        public PrivateClassWriter(int flags, ClassLoader classpath) {
            super(flags);
            this.classpath = classpath;
        }

        protected ClassLoader getClassLoader() {
            return this.classpath;
        }
    }
}

