/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="A single element of a batch response, often part of a list with other elements.")
public class ApiBatchResponseElement {
    @SerializedName(value="statusCode")
    private BigDecimal statusCode = null;
    @SerializedName(value="response")
    private Object response = null;

    public ApiBatchResponseElement statusCode(BigDecimal statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Schema(description="Read-only. The HTTP status code of the response.")
    public BigDecimal getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(BigDecimal statusCode) {
        this.statusCode = statusCode;
    }

    public ApiBatchResponseElement response(Object response) {
        this.response = response;
        return this;
    }

    @Schema(description="Read-only. The (optional) serialized body of the response, in the representation produced by the corresponding API endpoint, such as application/json.")
    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiBatchResponseElement apiBatchResponseElement = (ApiBatchResponseElement)o;
        return Objects.equals(this.statusCode, apiBatchResponseElement.statusCode) && Objects.equals(this.response, apiBatchResponseElement.response);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.response);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiBatchResponseElement {\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

