/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.util.Deque;
import java.util.LinkedList;

public class PooledConnectionStatistics {
    private final int size;
    private final Deque<Long> availableStats;
    private final Deque<Long> activeStats;

    public PooledConnectionStatistics(int i) {
        this.size = i;
        this.availableStats = new LinkedList<Long>(){

            @Override
            public boolean add(Long e) {
                if (PooledConnectionStatistics.this.size < 1) {
                    return false;
                }
                boolean b = super.add(e);
                while (this.size() > PooledConnectionStatistics.this.size) {
                    this.remove();
                }
                return b;
            }
        };
        this.activeStats = new LinkedList<Long>(){

            @Override
            public boolean add(Long e) {
                if (PooledConnectionStatistics.this.size < 1) {
                    return false;
                }
                boolean b = super.add(e);
                while (this.size() > PooledConnectionStatistics.this.size) {
                    this.remove();
                }
                return b;
            }
        };
    }

    public Deque<Long> getAvailableStats() {
        return this.availableStats;
    }

    public Long getLastAvailableState() {
        return this.availableStats.peekLast();
    }

    public synchronized void addAvailableStat() {
        this.availableStats.add(System.currentTimeMillis());
    }

    public Deque<Long> getActiveStats() {
        return this.activeStats;
    }

    public Long getLastActiveStat() {
        return this.activeStats.peekLast();
    }

    public synchronized void addActiveStat() {
        this.activeStats.add(System.currentTimeMillis());
    }

    public String toString() {
        return String.format("[%s@%d::size=%s]", this.getClass().getName(), this.hashCode(), this.size);
    }
}

