/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;

class RemoteLogLeaderEpochState {
    private final NavigableMap<Long, RemoteLogSegmentId> offsetToId = new ConcurrentSkipListMap<Long, RemoteLogSegmentId>();
    private final Set<RemoteLogSegmentId> unreferencedSegmentIds = ConcurrentHashMap.newKeySet();
    private volatile Long highestLogOffset;

    RemoteLogLeaderEpochState() {
    }

    Iterator<RemoteLogSegmentMetadata> listAllRemoteLogSegments(Map<RemoteLogSegmentId, RemoteLogSegmentMetadata> idToSegmentMetadata) throws RemoteResourceNotFoundException {
        int size = this.offsetToId.size() + this.unreferencedSegmentIds.size();
        if (size == 0) {
            return Collections.emptyIterator();
        }
        ArrayList<RemoteLogSegmentMetadata> metadataList = new ArrayList<RemoteLogSegmentMetadata>(size);
        this.collectConvertedIdToMetadata(this.offsetToId.values(), idToSegmentMetadata, metadataList);
        if (!this.unreferencedSegmentIds.isEmpty()) {
            this.collectConvertedIdToMetadata(this.unreferencedSegmentIds, idToSegmentMetadata, metadataList);
            metadataList.sort(Comparator.comparingLong(RemoteLogSegmentMetadata::startOffset));
        }
        return metadataList.iterator();
    }

    private void collectConvertedIdToMetadata(Collection<RemoteLogSegmentId> segmentIds, Map<RemoteLogSegmentId, RemoteLogSegmentMetadata> idToSegmentMetadata, Collection<RemoteLogSegmentMetadata> result) throws RemoteResourceNotFoundException {
        for (RemoteLogSegmentId id : segmentIds) {
            RemoteLogSegmentMetadata metadata = idToSegmentMetadata.get(id);
            if (metadata == null) {
                throw new RemoteResourceNotFoundException("No remote log segment metadata found for :" + id);
            }
            result.add(metadata);
        }
    }

    void handleSegmentWithCopySegmentStartedState(RemoteLogSegmentId remoteLogSegmentId) {
        this.unreferencedSegmentIds.add(remoteLogSegmentId);
    }

    void handleSegmentWithCopySegmentFinishedState(Long startOffset, RemoteLogSegmentId remoteLogSegmentId, Long leaderEpochEndOffset) {
        Map.Entry<Long, RemoteLogSegmentId> lastEntry = this.offsetToId.lastEntry();
        while (lastEntry != null && lastEntry.getKey() >= startOffset && this.highestLogOffset <= leaderEpochEndOffset) {
            this.offsetToId.remove(lastEntry.getKey());
            this.unreferencedSegmentIds.add(lastEntry.getValue());
            lastEntry = this.offsetToId.lastEntry();
        }
        this.offsetToId.put(startOffset, remoteLogSegmentId);
        this.unreferencedSegmentIds.remove(remoteLogSegmentId);
        if (this.highestLogOffset == null || leaderEpochEndOffset > this.highestLogOffset) {
            this.highestLogOffset = leaderEpochEndOffset;
        }
    }

    void handleSegmentWithDeleteSegmentStartedState(Long startOffset, RemoteLogSegmentId remoteLogSegmentId) {
        this.offsetToId.remove(startOffset, remoteLogSegmentId);
        this.unreferencedSegmentIds.add(remoteLogSegmentId);
    }

    void handleSegmentWithDeleteSegmentFinishedState(RemoteLogSegmentId remoteLogSegmentId) {
        this.unreferencedSegmentIds.remove(remoteLogSegmentId);
    }

    Long highestLogOffset() {
        return this.highestLogOffset;
    }

    RemoteLogSegmentId floorEntry(long offset) {
        Map.Entry<Long, RemoteLogSegmentId> entry = this.offsetToId.floorEntry(offset);
        return entry == null ? null : entry.getValue();
    }

    Collection<RemoteLogSegmentId> unreferencedSegmentIds() {
        return Collections.unmodifiableCollection(this.unreferencedSegmentIds);
    }

    Collection<RemoteLogSegmentId> referencedSegmentIds() {
        return Collections.unmodifiableCollection(this.offsetToId.values());
    }

    @FunctionalInterface
    static interface Action {
        public void accept(int var1, RemoteLogLeaderEpochState var2, long var3, RemoteLogSegmentId var5);
    }
}

