/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;

public class ToolsUtils {
    public static void printMetrics(Map<MetricName, ? extends Metric> metrics) {
        if (metrics != null && !metrics.isEmpty()) {
            int maxLengthOfDisplayName = 0;
            TreeMap<String, Object> sortedMetrics = new TreeMap<String, Object>();
            for (Metric metric : metrics.values()) {
                MetricName mName = metric.metricName();
                String mergedName = mName.group() + ":" + mName.name() + ":" + mName.tags();
                maxLengthOfDisplayName = maxLengthOfDisplayName < mergedName.length() ? mergedName.length() : maxLengthOfDisplayName;
                sortedMetrics.put(mergedName, metric.metricValue());
            }
            String doubleOutputFormat = "%-" + maxLengthOfDisplayName + "s : %.3f";
            String string = "%-" + maxLengthOfDisplayName + "s : %s";
            System.out.println(String.format("\n%-" + maxLengthOfDisplayName + "s   %s", "Metric Name", "Value"));
            for (Map.Entry entry : sortedMetrics.entrySet()) {
                String outputFormat = entry.getValue() instanceof Double ? doubleOutputFormat : string;
                System.out.println(String.format(outputFormat, entry.getKey(), entry.getValue()));
            }
        }
    }

    private static void appendColumnValue(StringBuilder rowBuilder, String value, int length) {
        int padLength = length - value.length();
        rowBuilder.append(value);
        for (int i = 0; i < padLength; ++i) {
            rowBuilder.append(' ');
        }
    }

    private static void printRow(List<Integer> columnLengths, List<String> row, PrintStream out) {
        StringBuilder rowBuilder = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            Integer columnLength = columnLengths.get(i);
            String columnValue = row.get(i);
            ToolsUtils.appendColumnValue(rowBuilder, columnValue, columnLength);
            rowBuilder.append('\t');
        }
        out.println(rowBuilder);
    }

    public static void prettyPrintTable(List<String> headers, List<List<String>> rows, PrintStream out) {
        List<Integer> columnLengths = headers.stream().map(String::length).collect(Collectors.toList());
        for (List<String> row2 : rows) {
            for (int i = 0; i < headers.size(); ++i) {
                columnLengths.set(i, Math.max(columnLengths.get(i), row2.get(i).length()));
            }
        }
        ToolsUtils.printRow(columnLengths, headers, out);
        rows.forEach(row -> ToolsUtils.printRow(columnLengths, row, out));
    }

    public static void validateBootstrapServer(String hostPort) throws IllegalArgumentException {
        if (hostPort == null || hostPort.trim().isEmpty()) {
            throw new IllegalArgumentException("Error while validating the bootstrap address\n");
        }
        String[] hostPorts = hostPort.contains(",") ? hostPort.split(",") : new String[]{hostPort};
        String[] validHostPort = (String[])Arrays.stream(hostPorts).filter(hostPortData -> Utils.getPort((String)hostPortData) != null).toArray(String[]::new);
        if (validHostPort.length == 0 || validHostPort.length != hostPorts.length) {
            throw new IllegalArgumentException("Please provide valid host:port like host1:9091,host2:9092\n");
        }
    }

    public static <T> Set<T> duplicates(List<T> s) {
        HashSet set = new HashSet();
        HashSet duplicates = new HashSet();
        s.forEach(element -> {
            if (!set.add(element)) {
                duplicates.add(element);
            }
        });
        return duplicates;
    }

    public static <T> Set<T> minus(Set<T> set, T ... toRemove) {
        HashSet<T> res = new HashSet<T>(set);
        for (T t : toRemove) {
            res.remove(t);
        }
        return res;
    }

    public static void printUsageAndExit(OptionParser parser, String message) {
        CommandLineUtils.printUsageAndExit((OptionParser)parser, (String)message);
        throw new AssertionError((Object)"printUsageAndExit should not return, but it did.");
    }
}

