/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.DecryptInputStream;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.StandardException;

class StreamFileContainer
implements TypedFormat {
    protected static int formatIdInteger = 290;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int MIN_BUFFER_SIZE = 1024;
    protected static final int FIELD_STATUS = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
    protected static final int FIELD_HEADER_SIZE = StoredFieldHeader.size(FIELD_STATUS, 0, 4);
    protected ContainerKey identity;
    private BaseDataFileFactory dataFactory;
    private int bufferSize;
    private StorageFile file;
    private OutputStream fileOut;
    private DynamicByteArrayOutputStream out;
    private FormatIdOutputStream logicalDataOut;
    private InputStream fileIn;
    private BufferedInputStream bufferedIn;
    private DecryptInputStream decryptIn;
    private LimitInputStream limitIn;
    private FormatIdInputStream logicalDataIn;
    private StoredRecordHeader recordHeader;
    private byte[] ciphertext;
    private byte[] zeroBytes;
    private static final int STORAGE_FILE_EXISTS_ACTION = 1;
    private static final int STORAGE_FILE_DELETE_ACTION = 2;
    private static final int STORAGE_FILE_MKDIRS_ACTION = 3;
    private static final int STORAGE_FILE_GET_OUTPUT_STREAM_ACTION = 4;
    private static final int STORAGE_FILE_GET_INPUT_STREAM_ACTION = 5;
    private int actionCode;
    private StorageFile actionStorageFile;

    StreamFileContainer(ContainerKey containerKey, BaseDataFileFactory baseDataFileFactory) {
        this.identity = containerKey;
        this.dataFactory = baseDataFileFactory;
    }

    StreamFileContainer(ContainerKey containerKey, BaseDataFileFactory baseDataFileFactory, Properties properties) throws StandardException {
        this.identity = containerKey;
        this.dataFactory = baseDataFileFactory;
        this.file = this.getFileName(containerKey, true, false);
        if (this.privExists(this.file)) {
            throw StandardException.newException((String)"XSDF0.S", (Object[])new Object[]{this.file});
        }
        this.getContainerProperties(properties);
    }

    protected StreamFileContainer open(boolean bl) throws StandardException {
        this.file = this.getFileName(this.identity, false, true);
        if (!this.privExists(this.file)) {
            return null;
        }
        try {
            if (!bl) {
                this.fileIn = this.privGetInputStream(this.file);
                if (this.dataFactory.databaseEncrypted()) {
                    MemByteHolder memByteHolder = new MemByteHolder(16384);
                    this.decryptIn = new DecryptInputStream(this.fileIn, memByteHolder, this.dataFactory);
                    this.limitIn = new LimitInputStream(this.decryptIn);
                } else {
                    this.bufferedIn = new BufferedInputStream(this.fileIn, 16384);
                    this.limitIn = new LimitInputStream(this.bufferedIn);
                }
            } else {
                return null;
            }
            this.logicalDataIn = new FormatIdInputStream(this.limitIn);
            this.recordHeader = new StoredRecordHeader();
            this.recordHeader.read(this.logicalDataIn);
        }
        catch (IOException iOException) {
            throw StandardException.newException((String)"XSDF1.S", (Throwable)iOException, (Object[])new Object[]{this.file});
        }
        return this;
    }

    protected void close() {
        try {
            if (this.fileIn != null) {
                this.fileIn.close();
                this.fileIn = null;
                if (this.dataFactory.databaseEncrypted()) {
                    this.decryptIn.close();
                    this.decryptIn = null;
                } else {
                    this.bufferedIn.close();
                    this.bufferedIn = null;
                }
                this.logicalDataIn.close();
                this.logicalDataIn = null;
            }
            if (this.fileOut != null) {
                this.fileOut.close();
                this.logicalDataOut.close();
                this.fileOut = null;
                this.logicalDataOut = null;
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getTypeFormatId() {
        return 290;
    }

    public void getContainerProperties(Properties properties) throws StandardException {
        AccessFactory accessFactory = (AccessFactory)StreamFileContainer.getServiceModule(this.dataFactory, "org.apache.derby.iapi.store.access.AccessFactory");
        TransactionController transactionController = accessFactory == null ? null : accessFactory.getTransaction(StreamFileContainer.getContextService().getCurrentContextManager());
        this.bufferSize = PropertyUtil.getServiceInt(transactionController, properties, "derby.storage.streamFileBufferSize", 1024, Integer.MAX_VALUE, 16384);
    }

    public ContainerKey getIdentity() {
        return this.identity;
    }

    protected boolean use(StreamContainerHandle streamContainerHandle) throws StandardException {
        return true;
    }

    public void load(RowSource rowSource) throws StandardException {
        this.out = new DynamicByteArrayOutputStream(this.bufferSize);
        this.logicalDataOut = new FormatIdOutputStream(this.out);
        boolean bl = this.dataFactory.databaseEncrypted();
        if (bl) {
            if (this.zeroBytes == null) {
                this.zeroBytes = new byte[this.dataFactory.getEncryptionBlockSize() - 1];
            }
            this.out.write(this.zeroBytes, 0, this.dataFactory.getEncryptionBlockSize() - 1);
        }
        try {
            int n;
            int n2;
            this.fileOut = this.privGetOutputStream(this.file);
            FormatableBitSet formatableBitSet = rowSource.getValidColumns();
            DataValueDescriptor[] dataValueDescriptorArray = rowSource.getNextRowFromRowSource();
            int n3 = 0;
            if (formatableBitSet != null) {
                for (n2 = formatableBitSet.getLength() - 1; n2 >= 0; --n2) {
                    if (!formatableBitSet.isSet(n2)) continue;
                    n3 = n2 + 1;
                    break;
                }
            } else {
                n3 = dataValueDescriptorArray.length;
            }
            this.recordHeader = new StoredRecordHeader(0, n3);
            n2 = this.recordHeader.write(this.out);
            int n4 = n = formatableBitSet == null ? 0 : formatableBitSet.getLength();
            while (dataValueDescriptorArray != null) {
                int n5 = -1;
                for (int i = 0; i < n3; ++i) {
                    if (formatableBitSet == null) {
                        var10_11 = dataValueDescriptorArray[++n5];
                        this.writeColumn(var10_11);
                    } else if (n > i && formatableBitSet.isSet(i)) {
                        var10_11 = dataValueDescriptorArray[++n5];
                        this.writeColumn(var10_11);
                    } else {
                        this.writeColumn(null);
                    }
                    if (this.out.getUsed() < this.bufferSize && this.bufferSize - this.out.getUsed() >= 1024) continue;
                    this.writeToFile();
                }
                dataValueDescriptorArray = rowSource.getNextRowFromRowSource();
            }
            if (bl) {
                if (this.out.getUsed() > this.dataFactory.getEncryptionBlockSize() - 1) {
                    this.writeToFile();
                }
            } else if (this.out.getUsed() > 0) {
                this.writeToFile();
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)iOException, (Object[])new Object[0]);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() throws StandardException {
        block17: {
            try {
                if (this.dataFactory.databaseEncrypted()) {
                    int n = this.out.getUsed() - (this.dataFactory.getEncryptionBlockSize() - 1);
                    int n2 = n % this.dataFactory.getEncryptionBlockSize();
                    int n3 = n2 == 0 ? 0 : this.dataFactory.getEncryptionBlockSize() - n2;
                    int n4 = n2 == 0 ? this.dataFactory.getEncryptionBlockSize() - 1 : n2 - 1;
                    int n5 = n + n3;
                    if (n <= 0) {
                        return;
                    }
                    if (this.ciphertext == null) {
                        this.ciphertext = new byte[n5];
                    } else if (this.ciphertext.length < n5) {
                        this.ciphertext = new byte[n5];
                    }
                    this.dataFactory.encrypt(this.out.getByteArray(), n4, n5, this.ciphertext, 0, false);
                    CompressedNumber.writeInt(this.fileOut, n);
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileOut.write(this.ciphertext, 0, n5);
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.out.reset();
                    if (this.dataFactory.databaseEncrypted()) {
                        if (this.zeroBytes == null) {
                            this.zeroBytes = new byte[this.dataFactory.getEncryptionBlockSize() - 1];
                        }
                        this.out.write(this.zeroBytes, 0, this.dataFactory.getEncryptionBlockSize() - 1);
                    }
                    break block17;
                }
                if (this.out.getUsed() == 0) {
                    return;
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileOut.write(this.out.getByteArray(), 0, this.out.getUsed());
                }
                finally {
                    this.dataFactory.writeFinished();
                }
                this.out.reset();
            }
            catch (IOException iOException) {
                throw StandardException.newException((String)"XSDA4.S", (Throwable)iOException, (Object[])new Object[0]);
            }
        }
    }

    private void writeColumn(Object object) throws StandardException, IOException {
        Storable storable;
        int n = FIELD_STATUS;
        if (object == null) {
            n = StoredFieldHeader.setNonexistent(n);
            StoredFieldHeader.write(this.out, n, 0, 4);
            return;
        }
        if (object instanceof Storable && (storable = (Storable)object).isNull()) {
            n = StoredFieldHeader.setNull(n, true);
            StoredFieldHeader.write(this.out, n, 0, 4);
            return;
        }
        int n2 = this.out.getPosition();
        int n3 = 0;
        StoredFieldHeader.write(this.out, n, n3, 4);
        if (object instanceof StreamStorable && ((StreamStorable)object).returnStream() != null) {
            object = ((StreamStorable)object).returnStream();
        }
        if (object instanceof InputStream) {
            int n4;
            var5_6 = (InputStream)object;
            int n5 = Math.min(Math.max(((InputStream)var5_6).available(), 64), 8192);
            byte[] byArray = new byte[n5];
            while ((n4 = ((InputStream)var5_6).read(byArray)) != -1) {
                n3 += n4;
                this.out.write(byArray, 0, n4);
            }
        } else if (object instanceof Storable) {
            var5_6 = (Storable)object;
            var5_6.writeExternal(this.logicalDataOut);
            n3 = this.out.getPosition() - n2 - FIELD_HEADER_SIZE;
        } else {
            this.logicalDataOut.writeObject(object);
            n3 = this.out.getPosition() - n2 - FIELD_HEADER_SIZE;
        }
        int n6 = this.out.getPosition();
        this.out.setPosition(n2);
        StoredFieldHeader.write(this.out, n, n3, 4);
        if (!StoredFieldHeader.isNull(n)) {
            this.out.setPosition(n6);
        }
    }

    public boolean fetchNext(Object[] objectArray) throws StandardException {
        boolean bl = false;
        int n = 0;
        try {
            int n2 = this.recordHeader.getNumberFields();
            int n3 = 0;
            for (n = 0; n < n2 && n3 < objectArray.length; ++n) {
                Object object;
                this.limitIn.clearLimit();
                int n4 = StoredFieldHeader.readStatus(this.logicalDataIn);
                int n5 = StoredFieldHeader.readFieldDataLength(this.logicalDataIn, n4, 4);
                this.limitIn.setLimit(n5);
                Object object2 = objectArray[n3];
                if (StoredFieldHeader.isNullable(n4)) {
                    if (object2 == null) {
                        throw StandardException.newException((String)"XSDA6.S", (Object[])new Object[]{Integer.toString(n)});
                    }
                    if (!(object2 instanceof Storable)) {
                        throw StandardException.newException((String)"XSDA6.S", (Object[])new Object[]{object2.getClass().getName()});
                    }
                    object = (Storable)object2;
                    if (StoredFieldHeader.isNull(n4)) {
                        object.restoreToNull();
                        ++n3;
                        continue;
                    }
                    bl = true;
                    object.readExternal(this.logicalDataIn);
                    bl = false;
                    ++n3;
                    continue;
                }
                if (StoredFieldHeader.isNull(n4)) {
                    throw StandardException.newException((String)"XSDA6.S", (Object[])new Object[]{Integer.toString(n)});
                }
                object = objectArray[n3];
                if (object instanceof Externalizable) {
                    Externalizable externalizable = (Externalizable)object;
                    bl = true;
                    externalizable.readExternal(this.logicalDataIn);
                    bl = false;
                    ++n3;
                    continue;
                }
                object = null;
                bl = true;
                objectArray[n3] = this.logicalDataIn.readObject();
                bl = false;
                ++n3;
            }
        }
        catch (IOException iOException) {
            if (bl) {
                if (iOException instanceof EOFException) {
                    throw StandardException.newException((String)"XSDA7.S", (Throwable)iOException, (Object[])new Object[]{this.logicalDataIn.getErrorInfo()});
                }
                throw StandardException.newException((String)"XSDA8.S", (Throwable)iOException, (Object[])new Object[]{this.logicalDataIn.getErrorInfo()});
            }
            if (iOException instanceof InvalidClassException) {
                throw StandardException.newException((String)"XSDA8.S", (Throwable)iOException, (Object[])new Object[]{this.logicalDataIn.getErrorInfo()});
            }
            if (iOException instanceof EOFException && n == 0) {
                this.close();
                return false;
            }
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB9.D", (Throwable)iOException, (Object[])new Object[]{this.identity}));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw StandardException.newException((String)"XSDA9.S", (Throwable)classNotFoundException, (Object[])new Object[]{this.logicalDataIn.getErrorInfo()});
        }
        catch (LinkageError linkageError) {
            if (bl) {
                throw StandardException.newException((String)"XSDA8.S", (Throwable)linkageError, (Object[])new Object[]{this.logicalDataIn.getErrorInfo()});
            }
            throw linkageError;
        }
        return true;
    }

    public boolean removeContainer() throws StandardException {
        this.close();
        if (this.privExists(this.file)) {
            return this.privDelete(this.file);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile getFileName(ContainerKey containerKey, boolean bl, boolean bl2) throws StandardException {
        if (containerKey.getSegmentId() == -1L) {
            return this.dataFactory.storageFactory.newStorageFile(this.dataFactory.storageFactory.getTempDir(), "T" + containerKey.getContainerId() + ".tmp");
        }
        StorageFile storageFile = this.dataFactory.getContainerPath(containerKey, false);
        if (!this.privExists(storageFile)) {
            if (!bl) {
                return null;
            }
            StorageFile storageFile2 = storageFile.getParentDir();
            if (!this.privExists(storageFile2)) {
                BaseDataFileFactory baseDataFileFactory = this.dataFactory;
                synchronized (baseDataFileFactory) {
                    if (!this.privExists(storageFile2)) {
                        boolean bl3 = false;
                        IOException iOException = null;
                        try {
                            bl3 = this.privMkdirs(storageFile2);
                        }
                        catch (IOException iOException2) {
                            iOException = iOException2;
                        }
                        if (!bl3) {
                            if (bl2) {
                                return null;
                            }
                            throw StandardException.newException((String)"XSDF3.S", (Throwable)iOException, (Object[])new Object[]{storageFile2});
                        }
                    }
                }
            }
        }
        return storageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile storageFile) {
        this.actionCode = 1;
        this.actionStorageFile = storageFile;
        try {
            Object object = this.run();
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privMkdirs(StorageFile storageFile) throws IOException {
        this.actionCode = 3;
        this.actionStorageFile = storageFile;
        try {
            Object object = this.run();
            boolean bl = (Boolean)object;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile storageFile) {
        this.actionCode = 2;
        this.actionStorageFile = storageFile;
        try {
            Object object = this.run();
            boolean bl = (Boolean)object;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized OutputStream privGetOutputStream(StorageFile storageFile) throws FileNotFoundException {
        this.actionCode = 4;
        this.actionStorageFile = storageFile;
        try {
            OutputStream outputStream = (OutputStream)this.run();
            return outputStream;
        }
        catch (IOException iOException) {
            throw (FileNotFoundException)iOException;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    private synchronized InputStream privGetInputStream(StorageFile storageFile) throws FileNotFoundException {
        this.actionCode = 5;
        this.actionStorageFile = storageFile;
        try {
            InputStream inputStream = (InputStream)this.run();
            return inputStream;
        }
        catch (IOException iOException) {
            throw (FileNotFoundException)iOException;
        }
        finally {
            this.actionStorageFile = null;
        }
    }

    public Object run() throws IOException {
        switch (this.actionCode) {
            case 1: {
                return this.actionStorageFile.exists();
            }
            case 2: {
                return this.actionStorageFile.delete();
            }
            case 3: {
                boolean bl = this.actionStorageFile.mkdirs();
                this.actionStorageFile.limitAccessToOwner();
                return bl;
            }
            case 4: {
                return this.actionStorageFile.getOutputStream();
            }
            case 5: {
                return this.actionStorageFile.getInputStream();
            }
        }
        return null;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static Object getServiceModule(Object object, String string) {
        return Monitor.getServiceModule(object, string);
    }
}

