/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.TopologyRegistryTrustManagerProperties;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Base64;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.X509TrustManager;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TopologyRegistryTrustManager
implements X509TrustManager,
Serializable {
    @NotNull
    private static final String INTER_SERVER_CERT_OC = "ds-cfg-server-instance";
    @NotNull
    private static final String INTER_SERVER_CERT_AT = "ds-cfg-inter-server-certificate";
    @NotNull
    private static final String LISTENER_CERT_OC = "ds-cfg-server-instance-listener";
    @NotNull
    private static final String LISTENER_CERT_AT = "ds-cfg-listener-certificate";
    @NotNull
    static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private static final long serialVersionUID = -1535917071172094611L;
    @NotNull
    private final AtomicLong cacheExpirationTime;
    @NotNull
    private final AtomicReference<Set<X509Certificate>> cachedCertificates;
    private final boolean ignoreIssuerCertificateValidityWindow;
    private final boolean ignorePeerCertificateValidityWindow;
    private final boolean requirePeerCertificateInTopologyRegistry;
    @NotNull
    private final File configurationFile;
    private final long cacheDurationMillis;

    public TopologyRegistryTrustManager(@NotNull File configurationFile, long cacheDurationMillis) {
        this(TopologyRegistryTrustManager.getDefaultProperties(configurationFile, cacheDurationMillis));
    }

    @NotNull
    private static TopologyRegistryTrustManagerProperties getDefaultProperties(@NotNull File configurationFile, long cacheDurationMillis) {
        TopologyRegistryTrustManagerProperties properties = new TopologyRegistryTrustManagerProperties(configurationFile);
        properties.setCacheDuration(cacheDurationMillis, TimeUnit.MILLISECONDS);
        return properties;
    }

    public TopologyRegistryTrustManager(@NotNull TopologyRegistryTrustManagerProperties properties) {
        this.configurationFile = properties.getConfigurationFile();
        this.cacheDurationMillis = properties.getCacheDurationMillis();
        this.requirePeerCertificateInTopologyRegistry = properties.requirePeerCertificateInTopologyRegistry();
        this.ignorePeerCertificateValidityWindow = properties.ignorePeerCertificateValidityWindow();
        this.ignoreIssuerCertificateValidityWindow = properties.ignoreIssuerCertificateValidityWindow();
        this.cacheExpirationTime = new AtomicLong(0L);
        this.cachedCertificates = new AtomicReference(Collections.emptySet());
    }

    @NotNull
    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public long getCacheDurationMillis() {
        return this.cacheDurationMillis;
    }

    public boolean requirePeerCertificateInTopologyRegistry() {
        return this.requirePeerCertificateInTopologyRegistry;
    }

    public boolean ignorePeerCertificateValidityWindow() {
        return this.ignorePeerCertificateValidityWindow;
    }

    public boolean ignoreIssuerCertificateValidityWindow() {
        return this.ignoreIssuerCertificateValidityWindow;
    }

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        this.checkTrusted(chain);
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        this.checkTrusted(chain);
    }

    private void checkTrusted(@NotNull X509Certificate[] chain) throws CertificateException {
        Set<X509Certificate> cachedCerts;
        if (chain == null || chain.length == 0) {
            throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_NO_CHAIN.get());
        }
        long currentTime = System.currentTimeMillis();
        X509Certificate peerCert = chain[0];
        if (!this.ignorePeerCertificateValidityWindow) {
            if (currentTime < peerCert.getNotBefore().getTime()) {
                throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_PEER_NOT_YET_VALID.get(peerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotBefore())));
            }
            if (currentTime > peerCert.getNotAfter().getTime()) {
                throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_PEER_EXPIRED.get(peerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotAfter())));
            }
        }
        if (!this.ignoreIssuerCertificateValidityWindow) {
            for (int i = 1; i < chain.length; ++i) {
                X509Certificate issuerCert = chain[i];
                if (currentTime < issuerCert.getNotBefore().getTime()) {
                    throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_ISSUER_NOT_YET_VALID.get(peerCert.getSubjectX500Principal().getName("RFC2253"), issuerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotBefore())));
                }
                if (currentTime <= issuerCert.getNotAfter().getTime()) continue;
                throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_ISSUER_EXPIRED.get(peerCert.getSubjectX500Principal().getName("RFC2253"), issuerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotAfter())));
            }
        }
        if (!(cachedCerts = this.cachedCertificates.get()).isEmpty() && this.cacheExpirationTime.get() >= currentTime && this.mayTrustChainBasedOnCertificateSet(chain, cachedCerts)) {
            return;
        }
        Set<X509Certificate> topologyRegistryCertificates = this.readTopologyRegistryCertificates();
        if (this.cacheDurationMillis > 0L) {
            this.cachedCertificates.set(topologyRegistryCertificates);
            this.cacheExpirationTime.set(currentTime + this.cacheDurationMillis);
        }
        if (this.mayTrustChainBasedOnCertificateSet(chain, topologyRegistryCertificates)) {
            return;
        }
        if (this.requirePeerCertificateInTopologyRegistry || chain.length == 1) {
            throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_PEER_NOT_FOUND.get(peerCert.getSubjectX500Principal().getName("RFC2253")));
        }
        throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_PEER_OR_ISSUERS_NOT_FOUND.get(peerCert.getSubjectX500Principal().getName("RFC2253")));
    }

    private boolean mayTrustChainBasedOnCertificateSet(@NotNull X509Certificate[] chain, @NotNull Set<X509Certificate> certificateSet) {
        if (certificateSet.contains(chain[0])) {
            return true;
        }
        if (!this.requirePeerCertificateInTopologyRegistry) {
            for (int i = 1; i < chain.length; ++i) {
                if (!certificateSet.contains(chain[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Set<X509Certificate> readTopologyRegistryCertificates() throws CertificateException {
        try (LDIFReader ldifReader = new LDIFReader(this.configurationFile);){
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
            while (true) {
                Entry entry;
                try {
                    entry = ldifReader.readEntry();
                }
                catch (LDIFException e) {
                    Debug.debugException(e);
                    if (e.mayContinueReading()) continue;
                    throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_MALFORMED_CONFIG.get(this.configurationFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
                if (entry == null) {
                    Set<X509Certificate> set = Collections.unmodifiableSet(certs);
                    return set;
                }
                if (entry.hasObjectClass(INTER_SERVER_CERT_OC) && entry.hasAttribute(INTER_SERVER_CERT_AT)) {
                    this.parseCertificates(certs, entry.getAttribute(INTER_SERVER_CERT_AT));
                    continue;
                }
                if (!entry.hasObjectClass(LISTENER_CERT_OC) || !entry.hasAttribute(LISTENER_CERT_AT)) continue;
                this.parseCertificates(certs, entry.getAttribute(LISTENER_CERT_AT));
                continue;
                break;
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_ERROR_READING_CONFIG_FILE.get(this.configurationFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private void parseCertificates(@NotNull Set<X509Certificate> certs, @NotNull Attribute attr) {
        StringBuilder certBase64 = new StringBuilder();
        for (String value : attr.getValues()) {
            try {
                for (String line : StaticUtils.stringToLines(value)) {
                    if (line.equalsIgnoreCase("-----BEGIN CERTIFICATE-----")) continue;
                    if (line.equalsIgnoreCase("-----END CERTIFICATE-----")) {
                        byte[] certBytes = Base64.decode(certBase64.toString());
                        certBase64.setLength(0);
                        certs.add((X509Certificate)CryptoHelper.getCertificateFactory("X.509").generateCertificate(new ByteArrayInputStream(certBytes)));
                        continue;
                    }
                    certBase64.append(line);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TopologyRegistryTrustManager(configurationFile='");
        buffer.append(this.configurationFile.getAbsolutePath());
        buffer.append("', cacheDurationMillis=");
        buffer.append(this.cacheDurationMillis);
        buffer.append(", requirePeerCertificateInTopologyRegistry=");
        buffer.append(this.requirePeerCertificateInTopologyRegistry);
        buffer.append(", ignorePeerCertificateValidityWindow=");
        buffer.append(this.ignorePeerCertificateValidityWindow);
        buffer.append(", ignoreIssuerCertificateValidityWindow=");
        buffer.append(this.ignoreIssuerCertificateValidityWindow);
        buffer.append(')');
    }
}

