/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.s3.ResumeToken;
import software.amazon.awssdk.crt.s3.S3MetaRequest;

@SdkInternalApi
public class S3MetaRequestWrapper {
    private final S3MetaRequest delegate;
    private volatile boolean isClosed;
    private final Object lock = new Object();

    public S3MetaRequestWrapper(S3MetaRequest delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.isClosed = true;
                this.delegate.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReadWindow(long windowSize) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.delegate.incrementReadWindow(windowSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResumeToken pause() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                return this.delegate.pause();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.delegate.cancel();
            }
        }
    }
}

